<?php

namespace App\Http\Controllers;

use App\Models\Categorieblog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class CategorieblogController extends Controller
{
    public function index()
    {
        $categorieblogs = Categorieblog::orderBy('ordre')->paginate(10);
        return view('admin.categorieblogs.index', compact('categorieblogs'));
    }

    public function create()
    {
        return view('admin.categorieblogs.form');
    }

    public function store(Request $request)
    {
        $request->validate([
            'titre' => 'required|string|max:255',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'pub' => 'boolean',
            'ordre' => 'integer',
            'slug' => 'nullable|string|max:255',
            'meta_title' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string'
        ]);

        $data = $request->all();
        
        if ($request->hasFile('photo')) {
            $data['photo'] = $request->file('photo')->store('photos', 'public');
        }

        if (!isset($data['ordre'])) {
            $data['ordre'] = Categorieblog::max('ordre') + 1;
        }

        Categorieblog::create($data);

        return redirect()->route('admin.categorieblogs.index')->with('success', 'Catégorie blog créée avec succès');
    }

    public function edit(Categorieblog $categorieblog)
    {
        return view('admin.categorieblogs.form', compact('categorieblog'));
    }

    public function update(Request $request, Categorieblog $categorieblog)
    {
        $request->validate([
            'titre' => 'required|string|max:255',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'pub' => 'boolean',
            'ordre' => 'integer',
            'slug' => 'nullable|string|max:255',
            'meta_title' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string'
        ]);

        $data = $request->all();
        
        if ($request->hasFile('photo')) {
            if ($categorieblog->photo) {
                Storage::disk('public')->delete($categorieblog->photo);
            }
            $data['photo'] = $request->file('photo')->store('photos', 'public');
        }

        $categorieblog->update($data);

        return redirect()->route('admin.categorieblogs.index')->with('success', 'Catégorie blog modifiée avec succès');
    }

    public function destroy(Categorieblog $categorieblog)
    {
        if ($categorieblog->photo) {
            Storage::disk('public')->delete($categorieblog->photo);
        }
        
        $categorieblog->delete();

        return redirect()->route('admin.categorieblogs.index')->with('success', 'Catégorie blog supprimée avec succès');
    }
}
