<?php

namespace App\Http\Controllers;

use App\Models\Partenaire;
use Illuminate\Http\Request;

class PartenaireController extends Controller
{
    public function index()
    {
        $partenaires = Partenaire::orderBy('ordre', 'desc')->paginate(10);
        return view('admin.partenaires.index', compact('partenaires'));
    }

    public function create()
    {
        return view('admin.partenaires.form');
    }

    public function store(Request $request)
    {
        $request->validate([
            'titre' => 'required',
            'photo' => 'required|image|mimes:jpeg,png,jpg|max:2048',
            'pub' => 'required|in:0,1'
        ]);

        $photoPath = $request->file('photo')->store('photos', 'public');

        $partenaire = Partenaire::create([
            'titre' => $request->titre,
            'photo' => $photoPath,
            'pub' => $request->pub,
            'ordre' => 0
        ]);

        $partenaire->ordre = $partenaire->id;
        $partenaire->save();

        return redirect()->route('admin.partenaires.index')->with('success', 'Partenaire créé avec succès');
    }

    public function edit(Partenaire $partenaire)
    {
        return view('admin.partenaires.form', compact('partenaire'));
    }

    public function update(Request $request, Partenaire $partenaire)
    {
        $request->validate([
            'titre' => 'required',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'pub' => 'required|in:0,1'
        ]);

        $photoPath = $partenaire->photo;
        if ($request->hasFile('photo')) {
            $photoPath = $request->file('photo')->store('photos', 'public');
        }

        $partenaire->update([
            'titre' => $request->titre,
            'photo' => $photoPath,
            'pub' => $request->pub
        ]);

        return redirect()->route('admin.partenaires.edit', $partenaire)->with('success', 'Sauvegarde effectuée avec succès');
    }

    public function destroy(Partenaire $partenaire)
    {
        $partenaire->delete();
        return redirect()->route('admin.partenaires.index')->with('success', 'Partenaire supprimé avec succès');
    }

    public function moveUp(Partenaire $partenaire)
    {
        $upperPartenaire = Partenaire::where('ordre', '>', $partenaire->ordre)
            ->orderBy('ordre', 'asc')
            ->first();

        if ($upperPartenaire) {
            $tempOrdre = $partenaire->ordre;
            $partenaire->ordre = $upperPartenaire->ordre;
            $upperPartenaire->ordre = $tempOrdre;

            $partenaire->save();
            $upperPartenaire->save();
        }

        return redirect()->route('admin.partenaires.index')->with('success', 'Partenaire déplacé vers le haut');
    }

    public function moveDown(Partenaire $partenaire)
    {
        $lowerPartenaire = Partenaire::where('ordre', '<', $partenaire->ordre)
            ->orderBy('ordre', 'desc')
            ->first();

        if ($lowerPartenaire) {
            $tempOrdre = $partenaire->ordre;
            $partenaire->ordre = $lowerPartenaire->ordre;
            $lowerPartenaire->ordre = $tempOrdre;

            $partenaire->save();
            $lowerPartenaire->save();
        }

        return redirect()->route('admin.partenaires.index')->with('success', 'Partenaire déplacé vers le bas');
    }

    public function togglePublication($id)
    {
        $partenaire = Partenaire::findOrFail($id);
        $partenaire->pub = !$partenaire->pub;
        $partenaire->save();

        return redirect()->route('admin.partenaires.index');
    }
}
