<?php

namespace App\Http\Controllers;

use App\Models\Photocolori;
use App\Models\Colori;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PhotocoloriController extends Controller
{
    public function index()
    {
        $photocoloris = Photocolori::with('colori')->paginate(10);
        return view('admin.photocoloris.index', compact('photocoloris'));
    }

    public function create()
    {
        $coloris = Colori::orderBy('titre')->get();
        return view('admin.photocoloris.form', compact('coloris'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'colori_id' => 'required|exists:coloris,id',
            'photo' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048'
        ]);

        $data = $request->all();
        
        if ($request->hasFile('photo')) {
            $data['photo'] = $request->file('photo')->store('photos', 'public');
        }

        Photocolori::create($data);

        return redirect()->route('photocoloris.index')->with('success', 'Photo colori créée avec succès');
    }

    public function edit(Photocolori $photocolori)
    {
        $coloris = Colori::orderBy('titre')->get();
        return view('admin.photocoloris.form', compact('photocolori', 'coloris'));
    }

    public function update(Request $request, Photocolori $photocolori)
    {
        $request->validate([
            'colori_id' => 'required|exists:coloris,id',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048'
        ]);

        $data = $request->all();
        
        if ($request->hasFile('photo')) {
            if ($photocolori->photo) {
                Storage::disk('public')->delete($photocolori->photo);
            }
            $data['photo'] = $request->file('photo')->store('photos', 'public');
        }

        $photocolori->update($data);

        return redirect()->route('photocoloris.index')->with('success', 'Photo colori modifiée avec succès');
    }

    public function destroy(Photocolori $photocolori)
    {
        try {
            if ($photocolori->photo) {
                Storage::disk('public')->delete($photocolori->photo);
            }
            
            $photocolori->delete();

            if (request()->ajax() || request()->expectsJson()) {
                return response()->json(['success' => true, 'message' => 'Photo supprimée avec succès']);
            }

            return redirect()->route('admin.photocoloris.index')->with('success', 'Photo colori supprimée avec succès');
        } catch (\Exception $e) {
            if (request()->ajax() || request()->expectsJson()) {
                return response()->json(['success' => false, 'message' => 'Erreur lors de la suppression'], 500);
            }
            
            return redirect()->back()->with('error', 'Erreur lors de la suppression de la photo');
        }
    }
}
