<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Devi extends Model
{
    protected $table = 'devis';
    
    protected $fillable = [
        'statut', 'matiere_id', 'colori_id', 'finition_id', 'bordure_id', 'client_id', 
        'devis_pdf', 'total_ht', 'tva', 'addperc', 'user_id', 'addperc'
    ];

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function matiere()
    {
        return $this->belongsTo(Matiere::class);
    }

    public function colori()
    {
        return $this->belongsTo(Colori::class);
    }

    public function finition()
    {
        return $this->belongsTo(Finition::class);
    }

    public function bordure()
    {
        return $this->belongsTo(Bordure::class);
    }

    public function optionsdecoupes()
    {
        return $this->hasMany(DeviOptionsdecoupe::class);
    }

    public function services()
    {
        return $this->hasMany(DeviService::class);
    }

    public function prixcoloris()
    {
        return $this->hasMany(DeviPrixcolori::class);
    }

    public function accessoires()
    {
        return $this->hasMany(AccessoireDevi::class);
    }

    public function bordures()
    {
        return $this->hasMany(BordureDevi::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
