<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Prixcolori extends Model
{
    protected $fillable = ['colori_id', 'finition_id', 'epaisseur_id', 'prix'];

    public function colori()
    {
        return $this->belongsTo(Colori::class);
    }

    public function finition()
    {
        return $this->belongsTo(Finition::class);
    }

    public function epaisseur()
    {
        return $this->belongsTo(Epaisseur::class);
    }

    /**
     * Vérifier si une combinaison finition+épaisseur existe déjà pour ce coloris
     */
    public static function combinaisonExiste($coloriId, $finitionId, $epaisseurId, $excludeId = null)
    {
        $query = self::where('colori_id', $coloriId)
                    ->where('finition_id', $finitionId)
                    ->where('epaisseur_id', $epaisseurId);
        
        if ($excludeId) {
            $query->where('id', '!=', $excludeId);
        }
        
        return $query->exists();
    }
}
