
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('postcategories', function (Blueprint $table) {
            $table->bigInteger('ordre')->nullable()->after('slug');
            $table->string('meta_title', 255)->nullable()->after('ordre');
            $table->text('meta_description')->nullable()->after('meta_title');
        });
    }

    public function down()
    {
        Schema::table('postcategories', function (Blueprint $table) {
            $table->dropColumn(['ordre', 'meta_title', 'meta_description']);
        });
    }
};
