
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('accessoires', function (Blueprint $table) {
            $table->id();
            $table->string('titre');
            $table->text('description')->nullable();
            $table->text('content')->nullable();
            $table->string('ref')->nullable();
            $table->double('prix');
            $table->string('photo');
            $table->foreignId('accessoiremarque_id')->constrained('accessoiremarques');
            $table->foreignId('categorieaccessoire_id')->constrained('categorieaccessoires');
            $table->boolean('pub')->default(1);
            $table->bigInteger('ordre')->default(0);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('accessoires');
    }
};
