
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('devis', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('statut');
            $table->unsignedBigInteger('matiere_id');
            $table->unsignedBigInteger('colori_id');
            $table->unsignedBigInteger('finition_id');
            $table->unsignedBigInteger('client_id');
            $table->string('devis_pdf');
            $table->double('total_ht');
            $table->integer('tva');
            $table->timestamps();

            $table->foreign('matiere_id')->references('id')->on('matieres');
            $table->foreign('colori_id')->references('id')->on('coloris');
            $table->foreign('finition_id')->references('id')->on('finitions');
            $table->foreign('client_id')->references('id')->on('clients');
        });
    }

    public function down()
    {
        Schema::dropIfExists('devis');
    }
};
