
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('devi_service', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('devi_id');
            $table->unsignedBigInteger('service_id');
            $table->double('devis_prix');
            $table->timestamps();

            $table->foreign('devi_id')->references('id')->on('devis');
            $table->foreign('service_id')->references('id')->on('services');
        });
    }

    public function down()
    {
        Schema::dropIfExists('devi_service');
    }
};
