
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('accessoire_devi', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('devi_id');
            $table->unsignedBigInteger('accessoire_id');
            $table->bigInteger('quantite');
            $table->double('prixu');
            $table->double('montant');
            $table->timestamps();

            $table->foreign('devi_id')->references('id')->on('devis');
            $table->foreign('accessoire_id')->references('id')->on('accessoires');
        });
    }

    public function down()
    {
        Schema::dropIfExists('accessoire_devi');
    }
};
