
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('devis', function (Blueprint $table) {
            $table->integer('addperc')->nullable()->after('tva');
            $table->unsignedBigInteger('user_id')->nullable()->after('addperc');
            
            // Ajouter la clé étrangère pour user_id
            $table->foreign('user_id')->references('id')->on('users');
        });
    }

    public function down()
    {
        Schema::table('devis', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropColumn(['addperc', 'user_id']);
        });
    }
};
