
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('telephone')->nullable()->after('email');
            $table->string('adresse')->nullable()->after('telephone');
            $table->string('ville')->nullable()->after('adresse');
            $table->string('code_postal')->nullable()->after('ville');
            $table->string('pays')->default('France')->after('code_postal');
            $table->enum('role', ['admin', 'user', 'manager'])->default('user')->after('pays');
            $table->date('date_naissance')->nullable()->after('role');
            $table->text('notes')->nullable()->after('date_naissance');
            $table->timestamp('derniere_connexion')->nullable()->after('notes');
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'telephone',
                'adresse',
                'ville',
                'code_postal',
                'pays',
                'role',
                'date_naissance',
                'notes',
                'derniere_connexion'
            ]);
        });
    }
};
