<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Colori;
use App\Models\Matiere;

class ColoriSeeder extends Seeder
{
    public function run(): void
    {
        // Récupérer les matières existantes
        $granit = Matiere::where('titre', 'Granit')->first();
        $marbre = Matiere::where('titre', 'Marbre')->first();
        $quartz = Matiere::where('titre', 'Quartz')->first();

        $coloris = [];

        // Coloris pour Granit
        if ($granit) {
            $colorisGranit = [
                'Noir Zimbabwe',
                'Gris Tarn',
                'Rose Clarté',
                'Bleu de Lanhelin',
                'Jaune Lamartine',
                'Rouge Vanga',
                'Vert Olive',
                'Blanc Cristal'
            ];

            foreach ($colorisGranit as $index => $nom) {
                $coloris[] = [
                    'matiere_id' => $granit->id,
                    'titre' => $nom,
                    'photo' => 'granit-' . strtolower(str_replace(' ', '-', $nom)) . '.jpg',
                    'pub' => 1,
                    'ordre' => $index + 1,
                    'slug' => strtolower(str_replace(' ', '-', $nom)),
                    'meta_title' => 'Granit ' . $nom,
                    'meta_description' => 'Découvrez notre granit ' . $nom . ' de qualité supérieure.',
                ];
            }
        }

        // Coloris pour Marbre
        if ($marbre) {
            $colorisMarbre = [
                'Carrare Blanc',
                'Emperador Dark',
                'Calacatta Gold',
                'Nero Marquina',
                'Travertin Beige',
                'Rouge Alicante',
                'Vert Guatemala'
            ];

            foreach ($colorisMarbre as $index => $nom) {
                $coloris[] = [
                    'matiere_id' => $marbre->id,
                    'titre' => $nom,
                    'photo' => 'marbre-' . strtolower(str_replace(' ', '-', $nom)) . '.jpg',
                    'pub' => 1,
                    'ordre' => $index + 1,
                    'slug' => strtolower(str_replace(' ', '-', $nom)),
                    'meta_title' => 'Marbre ' . $nom,
                    'meta_description' => 'Découvrez notre marbre ' . $nom . ' de qualité supérieure.',
                ];
            }
        }

        // Coloris pour Quartz
        if ($quartz) {
            $colorisQuartz = [
                'Blanc Pur',
                'Gris Béton',
                'Noir Profond',
                'Beige Sable',
                'Bleu Océan',
                'Vert Émeraude'
            ];

            foreach ($colorisQuartz as $index => $nom) {
                $coloris[] = [
                    'matiere_id' => $quartz->id,
                    'titre' => $nom,
                    'photo' => 'quartz-' . strtolower(str_replace(' ', '-', $nom)) . '.jpg',
                    'pub' => 1,
                    'ordre' => $index + 1,
                    'slug' => strtolower(str_replace(' ', '-', $nom)),
                    'meta_title' => 'Quartz ' . $nom,
                    'meta_description' => 'Découvrez notre quartz ' . $nom . ' de qualité supérieure.',
                ];
            }
        }

        foreach ($coloris as $colori) {
            Colori::create($colori);
        }
    }
}
