<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        $users =[
            [
                'name' => 'karim',
                'email' => 'admin@onestcom.com',
                'password' => bcrypt('12345678'),
                'role_id' => 1,
                'is_active' => 1,
            ],
            [
                'name' => 'Manager',
                'email' => 'manager@onestcom.com',
                'password' => bcrypt('12345678'),
                'role_id' => 2,
                'is_active' => 1,
            ],
            [
                'name' => 'Test User',
                'email' => 'user@onestcom.com',
                'password' => bcrypt('12345678'),
                'role_id' => 3,
                'is_active' => 1,
            ],
        ];

        foreach ($users as $user) {
            User::create($user);
        }

        $this->call([
            FinitionSeeder::class,
            EpaisseurSeeder::class,
            ColoriSeeder::class,
            RolePermissionSeeder::class
        ]);
    }
}
