<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Permission;

class RolePermissionSeeder extends Seeder
{
    public function run()
    {
        // Vider les tables avant d'insérer les nouvelles données
        \DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        \DB::table('role_permission')->truncate();
        \DB::table('permissions')->truncate();
        \DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        // Créer les permissions
        $permissions = [
            // Gestion des utilisateurs
            ['name' => 'users.view', 'display_name' => 'Voir les utilisateurs', 'category' => 'users', 'description' => 'Permet de voir la liste des utilisateurs'],
            ['name' => 'users.create', 'display_name' => 'Créer des utilisateurs', 'category' => 'users', 'description' => 'Permet de créer de nouveaux utilisateurs'],
            ['name' => 'users.edit', 'display_name' => 'Modifier les utilisateurs', 'category' => 'users', 'description' => 'Permet de modifier les utilisateurs existants'],
            ['name' => 'users.delete', 'display_name' => 'Supprimer les utilisateurs', 'category' => 'users', 'description' => 'Permet de supprimer des utilisateurs'],
            
            // Gestion des rôles
            ['name' => 'roles.view', 'display_name' => 'Voir les rôles', 'category' => 'roles', 'description' => 'Permet de voir la liste des rôles'],
            ['name' => 'roles.create', 'display_name' => 'Créer des rôles', 'category' => 'roles', 'description' => 'Permet de créer de nouveaux rôles'],
            ['name' => 'roles.edit', 'display_name' => 'Modifier les rôles', 'category' => 'roles', 'description' => 'Permet de modifier les rôles existants'],
            ['name' => 'roles.delete', 'display_name' => 'Supprimer les rôles', 'category' => 'roles', 'description' => 'Permet de supprimer des rôles'],
            
            // Gestion des permissions
            ['name' => 'permissions.view', 'display_name' => 'Voir les permissions', 'category' => 'permissions', 'description' => 'Permet de voir la liste des permissions'],
            ['name' => 'permissions.create', 'display_name' => 'Créer des permissions', 'category' => 'permissions', 'description' => 'Permet de créer de nouvelles permissions'],
            ['name' => 'permissions.edit', 'display_name' => 'Modifier les permissions', 'category' => 'permissions', 'description' => 'Permet de modifier les permissions existantes'],
            ['name' => 'permissions.delete', 'display_name' => 'Supprimer les permissions', 'category' => 'permissions', 'description' => 'Permet de supprimer des permissions'],
            
            // Gestion des devis
            ['name' => 'devis.view', 'display_name' => 'Voir les devis', 'category' => 'devis', 'description' => 'Permet de voir la liste des devis'],
            ['name' => 'devis.create', 'display_name' => 'Créer des devis', 'category' => 'devis', 'description' => 'Permet de créer de nouveaux devis'],
            ['name' => 'devis.edit', 'display_name' => 'Modifier les devis', 'category' => 'devis', 'description' => 'Permet de modifier les devis existants'],
            ['name' => 'devis.delete', 'display_name' => 'Supprimer les devis', 'category' => 'devis', 'description' => 'Permet de supprimer des devis'],
            
            // Gestion des matières
            ['name' => 'matieres.view', 'display_name' => 'Voir les matières', 'category' => 'matieres', 'description' => 'Permet de voir la liste des matières'],
            ['name' => 'matieres.create', 'display_name' => 'Créer des matières', 'category' => 'matieres', 'description' => 'Permet de créer de nouvelles matières'],
            ['name' => 'matieres.edit', 'display_name' => 'Modifier les matières', 'category' => 'matieres', 'description' => 'Permet de modifier les matières existantes'],
            ['name' => 'matieres.delete', 'display_name' => 'Supprimer les matières', 'category' => 'matieres', 'description' => 'Permet de supprimer des matières'],
            
            // Gestion des catégories de matières
            ['name' => 'categoriematieres.view', 'display_name' => 'Voir les catégories de matières', 'category' => 'matieres', 'description' => 'Permet de voir les catégories de matières'],
            ['name' => 'categoriematieres.create', 'display_name' => 'Créer des catégories de matières', 'category' => 'matieres', 'description' => 'Permet de créer des catégories de matières'],
            ['name' => 'categoriematieres.edit', 'display_name' => 'Modifier les catégories de matières', 'category' => 'matieres', 'description' => 'Permet de modifier les catégories de matières'],
            ['name' => 'categoriematieres.delete', 'display_name' => 'Supprimer les catégories de matières', 'category' => 'matieres', 'description' => 'Permet de supprimer des catégories de matières'],
            
            // Gestion des coloris
            ['name' => 'coloris.view', 'display_name' => 'Voir les coloris', 'category' => 'matieres', 'description' => 'Permet de voir la liste des coloris'],
            ['name' => 'coloris.create', 'display_name' => 'Créer des coloris', 'category' => 'matieres', 'description' => 'Permet de créer de nouveaux coloris'],
            ['name' => 'coloris.edit', 'display_name' => 'Modifier les coloris', 'category' => 'matieres', 'description' => 'Permet de modifier les coloris existants'],
            ['name' => 'coloris.delete', 'display_name' => 'Supprimer les coloris', 'category' => 'matieres', 'description' => 'Permet de supprimer des coloris'],
            
            // Gestion des prix coloris
            ['name' => 'prixcoloris.view', 'display_name' => 'Voir les prix coloris', 'category' => 'matieres', 'description' => 'Permet de voir les prix des coloris'],
            ['name' => 'prixcoloris.create', 'display_name' => 'Créer des prix coloris', 'category' => 'matieres', 'description' => 'Permet de créer des prix coloris'],
            ['name' => 'prixcoloris.edit', 'display_name' => 'Modifier les prix coloris', 'category' => 'matieres', 'description' => 'Permet de modifier les prix coloris'],
            ['name' => 'prixcoloris.delete', 'display_name' => 'Supprimer les prix coloris', 'category' => 'matieres', 'description' => 'Permet de supprimer des prix coloris'],
            
            // Gestion des épaisseurs
            ['name' => 'epaisseurs.view', 'display_name' => 'Voir les épaisseurs', 'category' => 'parametres', 'description' => 'Permet de voir la liste des épaisseurs'],
            ['name' => 'epaisseurs.create', 'display_name' => 'Créer des épaisseurs', 'category' => 'parametres', 'description' => 'Permet de créer de nouvelles épaisseurs'],
            ['name' => 'epaisseurs.edit', 'display_name' => 'Modifier les épaisseurs', 'category' => 'parametres', 'description' => 'Permet de modifier les épaisseurs existantes'],
            ['name' => 'epaisseurs.delete', 'display_name' => 'Supprimer les épaisseurs', 'category' => 'parametres', 'description' => 'Permet de supprimer des épaisseurs'],
            
            // Gestion des finitions
            ['name' => 'finitions.view', 'display_name' => 'Voir les finitions', 'category' => 'parametres', 'description' => 'Permet de voir la liste des finitions'],
            ['name' => 'finitions.create', 'display_name' => 'Créer des finitions', 'category' => 'parametres', 'description' => 'Permet de créer de nouvelles finitions'],
            ['name' => 'finitions.edit', 'display_name' => 'Modifier les finitions', 'category' => 'parametres', 'description' => 'Permet de modifier les finitions existantes'],
            ['name' => 'finitions.delete', 'display_name' => 'Supprimer les finitions', 'category' => 'parametres', 'description' => 'Permet de supprimer des finitions'],
            
            // Gestion des bordures
            ['name' => 'bordures.view', 'display_name' => 'Voir les bordures', 'category' => 'parametres', 'description' => 'Permet de voir la liste des bordures'],
            ['name' => 'bordures.create', 'display_name' => 'Créer des bordures', 'category' => 'parametres', 'description' => 'Permet de créer de nouvelles bordures'],
            ['name' => 'bordures.edit', 'display_name' => 'Modifier les bordures', 'category' => 'parametres', 'description' => 'Permet de modifier les bordures existantes'],
            ['name' => 'bordures.delete', 'display_name' => 'Supprimer les bordures', 'category' => 'parametres', 'description' => 'Permet de supprimer des bordures'],
            
            // Gestion des options de découpe
            ['name' => 'optionsdecoupes.view', 'display_name' => 'Voir les options de découpe', 'category' => 'parametres', 'description' => 'Permet de voir les options de découpe'],
            ['name' => 'optionsdecoupes.create', 'display_name' => 'Créer des options de découpe', 'category' => 'parametres', 'description' => 'Permet de créer des options de découpe'],
            ['name' => 'optionsdecoupes.edit', 'display_name' => 'Modifier les options de découpe', 'category' => 'parametres', 'description' => 'Permet de modifier les options de découpe'],
            ['name' => 'optionsdecoupes.delete', 'display_name' => 'Supprimer les options de découpe', 'category' => 'parametres', 'description' => 'Permet de supprimer des options de découpe'],
            
            // Gestion des services
            ['name' => 'services.view', 'display_name' => 'Voir les services', 'category' => 'services', 'description' => 'Permet de voir la liste des services'],
            ['name' => 'services.create', 'display_name' => 'Créer des services', 'category' => 'services', 'description' => 'Permet de créer de nouveaux services'],
            ['name' => 'services.edit', 'display_name' => 'Modifier les services', 'category' => 'services', 'description' => 'Permet de modifier les services existants'],
            ['name' => 'services.delete', 'display_name' => 'Supprimer les services', 'category' => 'services', 'description' => 'Permet de supprimer des services'],
            
            // Gestion des accessoires
            ['name' => 'accessoires.view', 'display_name' => 'Voir les accessoires', 'category' => 'accessoires', 'description' => 'Permet de voir la liste des accessoires'],
            ['name' => 'accessoires.create', 'display_name' => 'Créer des accessoires', 'category' => 'accessoires', 'description' => 'Permet de créer de nouveaux accessoires'],
            ['name' => 'accessoires.edit', 'display_name' => 'Modifier les accessoires', 'category' => 'accessoires', 'description' => 'Permet de modifier les accessoires existants'],
            ['name' => 'accessoires.delete', 'display_name' => 'Supprimer les accessoires', 'category' => 'accessoires', 'description' => 'Permet de supprimer des accessoires'],
            
            // Gestion des catégories d'accessoires
            ['name' => 'categorieaccessoires.view', 'display_name' => 'Voir les catégories d\'accessoires', 'category' => 'accessoires', 'description' => 'Permet de voir les catégories d\'accessoires'],
            ['name' => 'categorieaccessoires.create', 'display_name' => 'Créer des catégories d\'accessoires', 'category' => 'accessoires', 'description' => 'Permet de créer des catégories d\'accessoires'],
            ['name' => 'categorieaccessoires.edit', 'display_name' => 'Modifier les catégories d\'accessoires', 'category' => 'accessoires', 'description' => 'Permet de modifier les catégories d\'accessoires'],
            ['name' => 'categorieaccessoires.delete', 'display_name' => 'Supprimer les catégories d\'accessoires', 'category' => 'accessoires', 'description' => 'Permet de supprimer des catégories d\'accessoires'],
            
            // Gestion des marques d'accessoires
            ['name' => 'accessoiremarques.view', 'display_name' => 'Voir les marques d\'accessoires', 'category' => 'accessoires', 'description' => 'Permet de voir les marques d\'accessoires'],
            ['name' => 'accessoiremarques.create', 'display_name' => 'Créer des marques d\'accessoires', 'category' => 'accessoires', 'description' => 'Permet de créer des marques d\'accessoires'],
            ['name' => 'accessoiremarques.edit', 'display_name' => 'Modifier les marques d\'accessoires', 'category' => 'accessoires', 'description' => 'Permet de modifier les marques d\'accessoires'],
            ['name' => 'accessoiremarques.delete', 'display_name' => 'Supprimer les marques d\'accessoires', 'category' => 'accessoires', 'description' => 'Permet de supprimer des marques d\'accessoires'],
            
            // Gestion du blog
            ['name' => 'blogs.view', 'display_name' => 'Voir les articles de blog', 'category' => 'blog', 'description' => 'Permet de voir les articles de blog'],
            ['name' => 'blogs.create', 'display_name' => 'Créer des articles de blog', 'category' => 'blog', 'description' => 'Permet de créer des articles de blog'],
            ['name' => 'blogs.edit', 'display_name' => 'Modifier les articles de blog', 'category' => 'blog', 'description' => 'Permet de modifier les articles de blog'],
            ['name' => 'blogs.delete', 'display_name' => 'Supprimer les articles de blog', 'category' => 'blog', 'description' => 'Permet de supprimer des articles de blog'],
            
            // Gestion des catégories de blog
            ['name' => 'categorieblogs.view', 'display_name' => 'Voir les catégories de blog', 'category' => 'blog', 'description' => 'Permet de voir les catégories de blog'],
            ['name' => 'categorieblogs.create', 'display_name' => 'Créer des catégories de blog', 'category' => 'blog', 'description' => 'Permet de créer des catégories de blog'],
            ['name' => 'categorieblogs.edit', 'display_name' => 'Modifier les catégories de blog', 'category' => 'blog', 'description' => 'Permet de modifier les catégories de blog'],
            ['name' => 'categorieblogs.delete', 'display_name' => 'Supprimer les catégories de blog', 'category' => 'blog', 'description' => 'Permet de supprimer des catégories de blog'],
            
            // Gestion des slides
            ['name' => 'slides.view', 'display_name' => 'Voir les slides', 'category' => 'contenu', 'description' => 'Permet de voir les slides du carousel'],
            ['name' => 'slides.create', 'display_name' => 'Créer des slides', 'category' => 'contenu', 'description' => 'Permet de créer des slides'],
            ['name' => 'slides.edit', 'display_name' => 'Modifier les slides', 'category' => 'contenu', 'description' => 'Permet de modifier les slides'],
            ['name' => 'slides.delete', 'display_name' => 'Supprimer les slides', 'category' => 'contenu', 'description' => 'Permet de supprimer des slides'],
            
            // Gestion des témoignages
            ['name' => 'temoinages.view', 'display_name' => 'Voir les témoignages', 'category' => 'contenu', 'description' => 'Permet de voir les témoignages'],
            ['name' => 'temoinages.create', 'display_name' => 'Créer des témoignages', 'category' => 'contenu', 'description' => 'Permet de créer des témoignages'],
            ['name' => 'temoinages.edit', 'display_name' => 'Modifier les témoignages', 'category' => 'contenu', 'description' => 'Permet de modifier les témoignages'],
            ['name' => 'temoinages.delete', 'display_name' => 'Supprimer les témoignages', 'category' => 'contenu', 'description' => 'Permet de supprimer des témoignages'],
            
            // Gestion des projets
            ['name' => 'nosprojets.view', 'display_name' => 'Voir les projets', 'category' => 'contenu', 'description' => 'Permet de voir les projets'],
            ['name' => 'nosprojets.create', 'display_name' => 'Créer des projets', 'category' => 'contenu', 'description' => 'Permet de créer des projets'],
            ['name' => 'nosprojets.edit', 'display_name' => 'Modifier les projets', 'category' => 'contenu', 'description' => 'Permet de modifier les projets'],
            ['name' => 'nosprojets.delete', 'display_name' => 'Supprimer les projets', 'category' => 'contenu', 'description' => 'Permet de supprimer des projets'],
            
            // Gestion des partenaires
            ['name' => 'partenaires.view', 'display_name' => 'Voir les partenaires', 'category' => 'contenu', 'description' => 'Permet de voir les partenaires'],
            ['name' => 'partenaires.create', 'display_name' => 'Créer des partenaires', 'category' => 'contenu', 'description' => 'Permet de créer des partenaires'],
            ['name' => 'partenaires.edit', 'display_name' => 'Modifier les partenaires', 'category' => 'contenu', 'description' => 'Permet de modifier les partenaires'],
            ['name' => 'partenaires.delete', 'display_name' => 'Supprimer les partenaires', 'category' => 'contenu', 'description' => 'Permet de supprimer des partenaires'],
            
            // Gestion des mots de passe
            ['name' => 'password.change', 'display_name' => 'Changer le mot de passe', 'category' => 'compte', 'description' => 'Permet de changer son mot de passe'],
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['name' => $permission['name']],
                $permission
            );
        }

        // Créer les rôles
        $adminRole = Role::firstOrCreate(
            ['name' => 'admin'],
            [
                'display_name' => 'Administrateur',
                'description' => 'Accès complet à toutes les fonctionnalités',
                'ordre' => 1,
                'is_active' => true,
            ]
        );

        $managerRole = Role::firstOrCreate(
            ['name' => 'manager'],
            [
                'display_name' => 'Manager',
                'description' => 'Accès à la gestion du contenu et des devis',
                'ordre' => 2,
                'is_active' => true,
            ]
        );

        $userRole = Role::firstOrCreate(
            ['name' => 'user'],
            [
                'display_name' => 'Utilisateur',
                'description' => 'Accès limité aux fonctionnalités de base',
                'ordre' => 3,
                'is_active' => true,
            ]
        );

        // Assigner toutes les permissions à l'admin
        $allPermissions = Permission::all();
        $adminRole->permissions()->sync($allPermissions->pluck('id'));

        // Assigner certaines permissions au manager
        $managerPermissions = Permission::whereIn('category', [
            'devis', 'matieres', 'parametres', 'services', 
            'accessoires', 'blog', 'contenu'
        ])->get();
        $managerRole->permissions()->sync($managerPermissions->pluck('id'));

        // Assigner des permissions limitées à l'utilisateur
        $userPermissions = Permission::whereIn('name', [
            'devis.view', 'matieres.view', 'coloris.view', 'services.view', 
            'accessoires.view', 'blogs.view', 'slides.view', 'temoinages.view',
            'nosprojets.view', 'partenaires.view', 'password.change'
        ])->get();
        $userRole->permissions()->sync($userPermissions->pluck('id'));
    }
}
