// STEP 1 -------------------
$(".nextstep").on("click", function (e) {
    e.preventDefault();
    let isValid = true;

    $(".accordion-item").find("label.error-message").remove();
    $(".accordion-item")
        .find("select,input,textarea")
        .removeClass("is-invalid");

    const accordionItem = $(this).closest(".accordion-item");

    accordionItem
        .find("select[required], input[required], textarea[required]")
        .each(function () {
            const $select = $(this);
            const selected = $select.val();
            const selectId = $select.attr("id");
            const type = $select.attr("type");
            const $label = $('label[for="' + selectId + '"]');

            if (!selected || selected === "") {
                isValid = false;
                $select.addClass("is-invalid");
                $label.after(
                    '<label class="error-message text-danger">Ce champ est requis.</label>',
                );
            }

            // Si email invalide
            if (type === "email") {
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(selected)) {
                    isValid = false;
                    $select.addClass("is-invalid");
                    $label.after(
                        '<label class="error-message"> Adresse email invalide.</label>',
                    );
                }
            }
        });

    // Si tout est OK → ouvrir le 2e accordion
    if (isValid) {
        let nextAccordion = accordionItem.next(".accordion-item");
        let nextCollapse = nextAccordion.find(".accordion-collapse");
        nextCollapse.collapse("show");

        const btn2 = $(".accordion-button.accordion2");
        btn2.attr("aria-disabled", false).attr("disabled", false);

        $("html, body").animate(
            {
                scrollTop: nextCollapse.offset().top - 200, // -100 pour un petit décalage visuel
            },
            500,
        );
    }
});

// STEP 2 -------------------
const matiereSelect = document.querySelector("#matiere_id");
const coloriSelect = document.querySelector("#colori_id");
const finitionSelect = document.querySelector('select[name="finition_id"]');

function initMaterialFiltering() {
    if (typeof axios === "undefined") return;

    // Configuration axios
    axios.defaults.headers.common["X-CSRF-TOKEN"] =
        document
            .querySelector('meta[name="csrf-token"]')
            ?.getAttribute("content") || "";

    if (!matiereSelect || !coloriSelect) return;

    // Changement de matière
    $("#matiere_id").on("change", function () {
        const matiereId = this.value;
        loadColorisForMatiere(matiereId);
    });

    // Changement de coloris
    $("#colori_id").on("change", function () {
        const coloriId = this.value;
        loadFinitionsForColoris(coloriId);
        resetRepeaterItems();
    });

    // Changement de finition
    $(document).on("change", 'select[name="finition_id"]', function () {
        const finitionId = this.value;
        const coloriId = $("#colori_id").val();
        if (coloriId && finitionId) {
            loadEpaisseursByColoriFinition(coloriId, finitionId);
        }
        resetRepeaterItems();
    });

    // Fonctions de chargement
    function loadColorisForMatiere(matiereId, selectedColoriId = null) {
        coloriSelect.innerHTML =
            '<option value="">Sélectionner un coloris</option>';

        if (matiereId) {
            const url = `${window.location.origin}/admin/coloris/by-matiere/${matiereId}`;
            axios
                .get(url.replace("http://", "https://"))
                .then((response) => {
                    const coloris = response.data;
                    if (Array.isArray(coloris) && coloris.length > 0) {
                        coloris.forEach((colori) => {
                            const option = document.createElement("option");
                            option.value = colori.id;
                            option.textContent = colori.titre;
                            if (
                                selectedColoriId &&
                                selectedColoriId == colori.id
                            ) {
                                option.selected = true;
                            }
                            coloriSelect.appendChild(option);
                        });
                    }
                    if (typeof $(coloriSelect).select2 === "function") {
                        $(coloriSelect).trigger("change");
                    }
                    updatePreview();
                })
                .catch((error) => {
                    console.error(
                        "Erreur lors du chargement des coloris:",
                        error,
                    );
                });
        }
    }

    function loadFinitionsForColoris(coloriId, selectedFinitionId = null) {
        if (!finitionSelect) return;

        finitionSelect.innerHTML =
            '<option value="">Sélectionner une finition</option>';

        if (coloriId) {
            const url = `${window.location.origin}/admin/finitions/by-coloris/${coloriId}`;
            axios
                .get(url.replace("http://", "https://"))
                .then((response) => {
                    const finitions = response.data;
                    if (Array.isArray(finitions) && finitions.length > 0) {
                        finitions.forEach((finition) => {
                            const option = document.createElement("option");
                            option.value = finition.id;
                            option.textContent = finition.titre;
                            if (
                                selectedFinitionId &&
                                selectedFinitionId == finition.id
                            ) {
                                option.selected = true;
                            }
                            finitionSelect.appendChild(option);
                        });
                    }
                    if (typeof $(finitionSelect).select2 === "function") {
                        $(finitionSelect).trigger("change");
                    }
                    updatePreview();
                })
                .catch((error) => {
                    console.error(
                        "Erreur lors du chargement des finitions:",
                        error,
                    );
                });
        }
    }

    function loadEpaisseursByColoriFinition(coloriId, finitionId) {
        const epaisseurSelects = document.querySelectorAll("select.epaisseur");
        epaisseurSelects.forEach((select) => {
            select.innerHTML =
                '<option value="">Choisissez une épaisseur</option>';
        });

        if (coloriId && finitionId) {
            const url = `${window.location.origin}/admin/epaisseurs/by-coloris-finition/${coloriId}/${finitionId}`;
            axios
                .get(url.replace("http://", "https://"))
                .then((response) => {
                    const epaisseurs = response.data;
                    window.currentEpaisseurs = epaisseurs;

                    if (Array.isArray(epaisseurs) && epaisseurs.length > 0) {
                        epaisseurSelects.forEach((select) => {
                            populateEpaisseurSelect(select);
                        });
                    }
                    updatePreview();
                })
                .catch((error) => {
                    console.error(
                        "Erreur lors du chargement des épaisseurs:",
                        error,
                    );
                    window.currentEpaisseurs = [];
                });
        }
    }

    // Charger les données initiales si en mode édition
    const initialMatiereId = matiereSelect.value;
    if (initialMatiereId) {
        const selectedColoriId = coloriSelect.value;
        loadColorisForMatiere(initialMatiereId, selectedColoriId);

        if (selectedColoriId) {
            const selectedFinitionId = finitionSelect?.value;
            setTimeout(() => {
                loadFinitionsForColoris(selectedColoriId, selectedFinitionId);
            }, 500);
        }
    }
}

//recap: Matiere-Coloris-Finition
function updatePreview() {
    const matiereText =
        matiereSelect.options[matiereSelect.selectedIndex]?.text;
    const coloriText = coloriSelect.options[coloriSelect.selectedIndex]?.text;
    const finitionText =
        finitionSelect?.options[finitionSelect.selectedIndex]?.text;

    const materialNameElement = document.getElementById("material-name");
    const coloriNameElement = document.getElementById("colori-name");
    const finishNameElement = document.getElementById("finish-name");

    if (
        materialNameElement &&
        matiereText &&
        matiereText !== "Sélectionner une matière"
    ) {
        materialNameElement.textContent = matiereText;
    }
    if (
        coloriNameElement &&
        coloriText &&
        coloriText !== "Sélectionner un coloris"
    ) {
        coloriNameElement.textContent = " - " + coloriText;
    }
    if (
        finishNameElement &&
        finitionText &&
        finitionText !== "Sélectionner une finition"
    ) {
        finishNameElement.textContent = finitionText;
    }

    // Mettre à jour l'image du coloris
    $("#colori_id").on("change", function () {
        getPhotoColoris();
    });
}

function getPhotoColoris() {
    const materialPreviewElement = document.getElementById("material-preview");
    const coloriId = coloriSelect.value;
    if (coloriId && materialPreviewElement) {
        // Charger la photo du coloris sélectionné

        const url = `${window.location.origin}/admin/coloris/${coloriId}/photo`;
        axios
            .get(url.replace("http://", "https://"))
            .then((response) => {
                console.log(
                    "Chargement de la photo du coloris:",
                    response.data,
                );
                if (response.data && response.data.photo) {
                    materialPreviewElement.src = `/storage/${response.data.photo}`;
                    materialPreviewElement.onerror = () => {
                        // Image par défaut si erreur de chargement
                        materialPreviewElement.src =
                            "/assets/media/avatars/granit-noir-zimbabwe-extra.jpg";
                    };
                } else {
                    // Image par défaut si pas de photo
                    materialPreviewElement.src =
                        "/assets/media/avatars/granit-noir-zimbabwe-extra.jpg";
                }
            })
            .catch((error) => {
                console.error(
                    "Erreur lors du chargement de la photo du coloris:",
                    error,
                );
                // Image par défaut en cas d'erreur
                materialPreviewElement.src =
                    "/assets/media/avatars/granit-noir-zimbabwe-extra.jpg";
            });
    } else if (materialPreviewElement) {
        // Image par défaut si aucun coloris sélectionné
        materialPreviewElement.src =
            "/assets/media/avatars/granit-noir-zimbabwe-extra.jpg";
    }
}
function populateEpaisseurSelect(select) {
    select.innerHTML = '<option value="">Choisissez une épaisseur</option>';

    if (window.currentEpaisseurs.length > 0) {
        window.currentEpaisseurs.forEach((epaisseur) => {
            const option = document.createElement("option");
            option.value = epaisseur.id;
            option.textContent = `${epaisseur.titre} - ${epaisseur.prix}€/m²`;
            option.setAttribute(
                "data-prix",
                epaisseur.prix_raw || epaisseur.prix,
            );
            option.setAttribute(
                "data-prix-colori-id",
                epaisseur.prix_colori_id,
            );
            select.appendChild(option);
        });
    }

    /*/ Réinitialiser Select2 pour ce select
    if ($(select).hasClass("select2-hidden-accessible")) {
        $(select).select2("destroy");
    }
    $(select).select2({
        minimumResultsForSearch: Infinity,
    });*/

    // Attacher les événements de calcul pour ce select spécifique
    ["change", "input"].forEach((event) => {
        select.removeEventListener(event, calculateTotal);
        select.addEventListener(event, calculateTotal);
    });
}

// Fonction pour mettre à jour le récapitulatif des plans de travail
function updatePdtRecap() {
    const pdtContainer = document.getElementById("pdt-id");
    if (!pdtContainer) return;

    // Vider le conteneur
    pdtContainer.innerHTML = "";

    let planIndex = 1;

    // Parcourir tous les éléments repeater des plans de travail
    document
        .querySelectorAll("#kt_docs_repeater_plantravail [data-repeater-item]")
        .forEach((item) => {
            const longueurInput = item.querySelector('input[name*="longueur"]');
            const largeurInput = item.querySelector('input[name*="largeur"]');
            const epaisseurSelect = item.querySelector(
                'select[name*="epaisseur"]',
            );

            if (!longueurInput || !largeurInput || !epaisseurSelect) return;

            const longueur = parseFloat(longueurInput.value) || 0;
            const largeur = parseFloat(largeurInput.value) || 0;
            const epaisseurId = epaisseurSelect.value;

            // Vérifier si tous les champs sont remplis et valides
            if (longueur > 0 && largeur > 0 && epaisseurId) {
                const selectedOption =
                    epaisseurSelect.options[epaisseurSelect.selectedIndex];
                const epaisseurText = selectedOption
                    ? selectedOption.textContent
                    : "";
                const prix =
                    parseFloat(selectedOption?.getAttribute("data-prix")) || 0;

                // Calculer la surface en m²
                const surface = (longueur * largeur) / 1000000;
                const coutTotal = surface * prix;

                // Créer l'élément récapitulatif
                const recapDiv = document.createElement("div");
                recapDiv.className = "pdt-name mb-2";
                recapDiv.innerHTML = `
                <div class="fw-bold mt-5">Plan de travail ${planIndex}</div>
                <div class="small text-muted">${longueur}mm × ${largeur}mm - Ep: ${epaisseurText}</div>
                <div class="text-success fw-bold">${coutTotal.toFixed(2)}€</div>
            `;

                pdtContainer.appendChild(recapDiv);
                planIndex++;
            }
        });

    // Si aucun plan valide, afficher un message par défaut
    if (pdtContainer.innerHTML === "") {
        pdtContainer.innerHTML = '<div class="pdt-name text-muted"></div>';
    }
}

//reinitialiser les valeurs des epaisseurs
function resetRepeaterItems() {
    ["kt_docs_repeater_plantravail", "kt_docs_repeater_credence"].forEach(
        (repeaterId) => {
            const repeaterList = document.querySelector(
                `[data-repeater-list="${repeaterId}"]`,
            );
            if (repeaterList) {
                const firstItem = repeaterList.querySelector(
                    "[data-repeater-item]",
                );
                const otherItems = repeaterList.querySelectorAll(
                    "[data-repeater-item]:not(:first-child)",
                );
                otherItems.forEach((item) => item.remove());

                if (firstItem) {
                    firstItem
                        .querySelectorAll("input, select")
                        .forEach((field) => {
                            field.value = "";
                            if (field.tagName === "SELECT") {
                                $(field).trigger("change");
                            }
                        });
                }
            }
        },
    );
}

// STEP 3 -------------------
$("#kt_docs_repeater_plantravail, #kt_docs_repeater_credence").repeater({
    initEmpty: false,

    defaultValues: {
        "text-input": "foo",
    },

    show: function () {
        $(this).slideDown();

        // Traiter d'abord les selects normaux
        $(this)
            .find('select[data-control="select2"]:not(.epaisseur)')
            .each(function () {
                if ($(this).hasClass("select2-hidden-accessible")) {
                    $(this).select2("destroy");
                }
                const hideSearch =
                    $(this).data("hide-search") === true ||
                    $(this).data("hide-search") === "true";

                $(this).select2({
                    minimumResultsForSearch: hideSearch ? Infinity : 0,
                });
                $(this)
                    .val($(this).find("option:first").val())
                    .trigger("change");
            });

        // Peupler les nouveaux selects d'épaisseur avec les données actuelles
        $(this)
            .find("select.epaisseur")
            .each(function () {
                populateEpaisseurSelect(this);
            });

        // Attacher les événements pour le récapitulatif aux nouveaux éléments
        $(this)
            .find(
                'input[name*="longueur"], input[name*="largeur"], select[name*="epaisseur"]',
            )
            .on("change input", function () {
                updatePdtRecap();
            });

        // Attacher les événements pour le récapitulatif des crédences aux nouveaux éléments
        $(this)
            .find(
                'input[name*="credence_longueur"], input[name*="credence_largeur"], select[name*="credence_epaisseur"]',
            )
            .on("change input", function () {
                updateCredenceRecap();
            });

        // Attacher les événements de calcul aux nouveaux éléments
        if (typeof attachCalculationListeners === "function") {
            attachCalculationListeners();
        }

        // Réinitialiser la validation en direct pour les nouveaux éléments
        //   setupLiveValidation();
    },

    hide: function (deleteElement) {
        // Compter le nombre d'éléments dans ce repeater
        const repeaterContainer = $(this).closest("[data-repeater-list]");
        const itemCount = repeaterContainer.find("[data-repeater-item]").length;

        if (itemCount <= 1) {
            alert(
                "Impossible de supprimer le dernier élément. Au moins un élément doit être présent.",
            );
            return;
        }

        if (confirm("Êtes-vous sûr de vouloir supprimer cet élément ?")) {
            $(this).slideUp(deleteElement);
            // Recalculer après suppression et mettre à jour le récapitulatif
            setTimeout(function () {
                if (typeof calculateTotal === "function") {
                    calculateTotal();
                }
                updatePdtRecap();
                updateCredenceRecap();
            }, 300); // Augmenter le délai pour s'assurer que l'élément est bien supprimé
        }
    },
});

// STEP 4 -------------------
function initBordureImageChange() {
    const bordureSelect = document.getElementById("bordure_id");
    const bordureImage = document.getElementById("bordureimage");

    if (bordureSelect && bordureImage) {
        bordureSelect.addEventListener("change", function () {
            const selectedOption = this.options[this.selectedIndex];
            let photoUrl = selectedOption.getAttribute("data-photo");

            if (
                photoUrl &&
                photoUrl !== "" &&
                photoUrl !== "null" &&
                photoUrl !== "undefined"
            ) {
                bordureImage.src = photoUrl;
                bordureImage.onload = () =>
                    console.log("Image chargée avec succès");
                bordureImage.onerror = () => {
                    const defaultImg =
                        "/assets/media/avatars/chant-droit-biseaute.jpg";
                    bordureImage.src = defaultImg;
                };
            } else {
                const defaultImg =
                    "/assets/media/avatars/chant-droit-biseaute.jpg";
                bordureImage.src = defaultImg;
            }

            // Mettre à jour le récapitulatif de la bordure
            updateBordureRecap();
        });

        // Déclencher le changement au chargement si une bordure est déjà sélectionnée
        if (bordureSelect.value) {
            setTimeout(() => {
                bordureSelect.dispatchEvent(new Event("change"));
            }, 100);
        }
    }
}

// Fonction pour mettre à jour le récapitulatif de la bordure
function updateBordureRecap() {
    const bordureSelect = document.getElementById("bordure_id");
    const bordureNameElement = document.getElementById("bordure-name");

    if (!bordureSelect || !bordureNameElement) return;

    const selectedValue = bordureSelect.value;
    const selectedOption = bordureSelect.options[bordureSelect.selectedIndex];

    const prix = parseFloat(selectedOption?.getAttribute("data-prix")) || 0;

    // Vérifier si une bordure est sélectionnée et que la valeur n'est pas vide ou 0
    if (selectedValue && selectedValue !== "" && selectedValue !== "0") {
        const bordureName = selectedOption.textContent;

        bordureNameElement.innerHTML = `
            <div class="fw-bold mt-5">Bordure</div>
            <div class="small text-muted">${bordureName}</div>
            <div class="text-success fw-bold">${prix.toFixed(2)}€</div>
        `;
    } else {
        // Effacer le récapitulatif si aucune bordure n'est sélectionnée ou si la valeur est vide/0
        bordureNameElement.textContent = "";
    }
}

// Fonction pour mettre à jour le récapitulatif des crédences
function updateCredenceRecap() {
    const credenceContainer = document.getElementById("credences-id");
    if (!credenceContainer) return;

    // Vider le conteneur
    credenceContainer.innerHTML = "";

    let credenceIndex = 1;

    // Parcourir tous les éléments repeater des crédences
    document
        .querySelectorAll("#kt_docs_repeater_credence [data-repeater-item]")
        .forEach((item) => {
            const longueurInput = item.querySelector(
                'input[name*="credence_longueur"]',
            );
            const largeurInput = item.querySelector(
                'input[name*="credence_largeur"]',
            );
            const epaisseurSelect = item.querySelector(
                'select[name*="credence_epaisseur"]',
            );

            if (!longueurInput || !largeurInput || !epaisseurSelect) return;

            const longueur = parseFloat(longueurInput.value) || 0;
            const largeur = parseFloat(largeurInput.value) || 0;
            const epaisseurId = epaisseurSelect.value;

            // Vérifier si tous les champs sont remplis et valides
            if (longueur > 0 && largeur > 0 && epaisseurId) {
                const selectedOption =
                    epaisseurSelect.options[epaisseurSelect.selectedIndex];
                const epaisseurText = selectedOption
                    ? selectedOption.textContent
                    : "";
                const prix =
                    parseFloat(selectedOption?.getAttribute("data-prix")) || 0;

                // Calculer la surface en m²
                const surface = (longueur * largeur) / 1000000;
                const coutTotal = surface * prix;

                // Créer l'élément récapitulatif
                const recapDiv = document.createElement("div");
                recapDiv.className = "credence-name mb-2";
                recapDiv.innerHTML = `
                <div class="fw-bold mt-5">Crédence ${credenceIndex}</div>
                <div class="small text-muted">${longueur}mm × ${largeur}mm - Ep: ${epaisseurText}</div>
                <div class="text-success fw-bold">${coutTotal.toFixed(2)}€</div>
            `;

                credenceContainer.appendChild(recapDiv);
                credenceIndex++;
            }
        });

    // Si aucune crédence valide, afficher un message par défaut
    if (credenceContainer.innerHTML === "") {
        credenceContainer.innerHTML =
            '<div class="credence-name text-muted"></div>';
    }
}

document.addEventListener("DOMContentLoaded", function () {
    // initWizardAccordion();
    initMaterialFiltering();
    initBordureImageChange();
    // attachCalculationListeners();

    // Initialiser le récapitulatif de bordure au chargement
    updateBordureRecap();

    // Attacher les événements pour le récapitulatif aux éléments existants
    document
        .querySelectorAll(
            '#kt_docs_repeater_plantravail input[name*="longueur"], #kt_docs_repeater_plantravail input[name*="largeur"], #kt_docs_repeater_plantravail select[name*="epaisseur"]',
        )
        .forEach(function (element) {
            element.addEventListener("change", updatePdtRecap);
            element.addEventListener("input", updatePdtRecap);
        });

    // Attacher les événements pour le récapitulatif des crédences aux éléments existants
    document
        .querySelectorAll(
            '#kt_docs_repeater_credence input[name*="credence_longueur"], #kt_docs_repeater_credence input[name*="credence_largeur"], #kt_docs_repeater_credence select[name*="credence_epaisseur"]',
        )
        .forEach(function (element) {
            element.addEventListener("change", updateCredenceRecap);
            element.addEventListener("input", updateCredenceRecap);
        });

    // Initialiser les récapitulatifs au chargement
    updatePdtRecap();
    updateCredenceRecap();

    // Observer les changements dans le container des plans de travail pour détecter les suppressions
    const pdtContainer = document.getElementById(
        "kt_docs_repeater_plantravail",
    );
    if (pdtContainer) {
        const observer = new MutationObserver(function (mutations) {
            let shouldUpdate = false;
            mutations.forEach(function (mutation) {
                if (mutation.type === "childList") {
                    // Détecter si des éléments ont été ajoutés ou supprimés
                    if (
                        mutation.removedNodes.length > 0 ||
                        mutation.addedNodes.length > 0
                    ) {
                        shouldUpdate = true;
                    }
                }
            });
            if (shouldUpdate) {
                setTimeout(updatePdtRecap, 100);
            }
        });

        observer.observe(pdtContainer, {
            childList: true,
            subtree: true,
        });
    }

    // Observer les changements dans le container des crédences pour détecter les suppressions
    const credenceContainer = document.getElementById(
        "kt_docs_repeater_credence",
    );
    if (credenceContainer) {
        const credenceObserver = new MutationObserver(function (mutations) {
            let shouldUpdate = false;
            mutations.forEach(function (mutation) {
                if (mutation.type === "childList") {
                    // Détecter si des éléments ont été ajoutés ou supprimés
                    if (
                        mutation.removedNodes.length > 0 ||
                        mutation.addedNodes.length > 0
                    ) {
                        shouldUpdate = true;
                    }
                }
            });
            if (shouldUpdate) {
                setTimeout(updateCredenceRecap, 100);
            }
        });

        credenceObserver.observe(credenceContainer, {
            childList: true,
            subtree: true,
        });
    }

    // Attacher les événements pour le récapitulatif des options de découpe
    document
        .querySelectorAll(
            '.optionsdecoupe-quantity, select[name*="optionsdecoupe"]',
        )
        .forEach(function (select) {
            select.addEventListener("change", updateOptionsRecap);
            select.addEventListener("input", updateOptionsRecap);
        });

    // Initialiser le récapitulatif des services au chargement
    updateServicesRecap();

    // Attacher les événements pour le récapitulatif des services
    document
        .querySelectorAll('input[name*="services"], .service-checkbox')
        .forEach(function (checkbox) {
            checkbox.addEventListener("change", updateServicesRecap);
        });

    // Initialiser le récapitulatif de la TVA au chargement
    updateTvaRecap();

    // Attacher les événements pour le récapitulatif de la TVA
    document
        .querySelectorAll('input[name*="tva"], .tva-checkbox')
        .forEach(function (checkbox) {
            checkbox.addEventListener("change", updateTvaRecap);
        });
});

// Recapulatif
function calculateTotal() {}

// Fonction pour mettre à jour le récapitulatif des options de découpe
function updateOptionsRecap() {
    const optionsContainer = document.getElementById("options-id");
    if (!optionsContainer) return;

    // Vider le conteneur
    optionsContainer.innerHTML = "";

    let optionIndex = 1;
    let hasValidOptions = false;

    // Récupérer tous les selects de quantité des options de découpe
    const quantitySelects = document.querySelectorAll(
        '.optionsdecoupe-quantity, select[name*="optionsdecoupe"]',
    );

    quantitySelects.forEach((select) => {
        const quantity = parseInt(select.value) || 0;

        // Vérifier si la quantité est valide (supérieure à 0)
        if (quantity > 0) {
            const prix = parseFloat(select.getAttribute("data-prix")) || 0;
            const optionText =
                select
                    .closest(".col-md-3, .form-group, .mb-3")
                    ?.querySelector(".form-label, label")
                    ?.textContent?.trim() ||
                select
                    .closest(".row")
                    ?.querySelector(".form-label, label")
                    ?.textContent?.trim() ||
                "";

            if (optionText) {
                const totalPrix = quantity * prix;

                // Créer l'élément récapitulatif
                const recapDiv = document.createElement("div");
                recapDiv.className = "option-name mb-2";
                recapDiv.innerHTML = `
                    <div class="fw-bold mt-5">Options et découpes ${optionIndex}</div>
                    <div class="text-gray-600">${optionText} (Qté: ${quantity})</div>
                    <div class="text-success fw-bold">${totalPrix.toFixed(2)}€</div>
                `;

                optionsContainer.appendChild(recapDiv);
                optionIndex++;
                hasValidOptions = true;
            }
        }
    });

    // Si aucune option valide, afficher un message par défaut
    if (!hasValidOptions) {
        optionsContainer.innerHTML =
            '<div class="option-name text-muted"></div>';
    }
}

// Fonction pour mettre à jour le récapitulatif des services
function updateServicesRecap() {
    const servicesContainer = document.getElementById("services-id");
    if (!servicesContainer) return;

    // Vider le conteneur
    servicesContainer.innerHTML = "";

    let serviceIndex = 1;
    let hasValidServices = false;

    // Récupérer tous les checkboxes de services cochés
    const checkedServices = document.querySelectorAll(
        'input[name*="services"]:checked, .service-checkbox:checked',
    );

    checkedServices.forEach((checkbox) => {
        const prix = parseFloat(checkbox.getAttribute("data-prix")) || 0;
        const serviceText =
            checkbox
                .closest(".form-check")
                ?.querySelector("label")
                ?.textContent?.trim() ||
            checkbox
                .closest(".col-md-6")
                ?.querySelector("label")
                ?.textContent?.trim() ||
            "";

        if (serviceText) {
            // Créer l'élément récapitulatif
            const recapDiv = document.createElement("div");
            recapDiv.className = "service-name mb-2";
            recapDiv.innerHTML = `
                <div class="fw-bold mt-5">Service ${serviceIndex}</div>
                <div class="text-gray-600">${serviceText}</div>
                <div class="text-success fw-bold">${prix.toFixed(2)}€</div>
            `;

            servicesContainer.appendChild(recapDiv);
            serviceIndex++;
            hasValidServices = true;
        }
    });

    // Si aucun service sélectionné, afficher un message par défaut
    if (!hasValidServices) {
        servicesContainer.innerHTML =
            '<div class="service-name text-muted"></div>';
    }
}

// Fonction pour mettre à jour le récapitulatif de la TVA
function updateTvaRecap() {
    const tvaContainer = document.getElementById("tva-id");
    if (!tvaContainer) return;

    // Récupérer la checkbox de TVA
    const tvaCheckbox = document.querySelector('input[name="tva"]');

    if (tvaCheckbox) {
        // Vérifier si la checkbox est cochée
        const isChecked = tvaCheckbox.checked;
        const tvaRate = isChecked ? "10%" : "20%";

        // Mettre à jour le contenu avec le taux approprié
        tvaContainer.textContent = tvaRate;
    } else {
        // Si pas de checkbox trouvée, afficher 20% par défaut
        tvaContainer.textContent = "20%";
    }
}
