
$(document).ready(function () {
  
  // Étape initiale : on désactive tous sauf le premier
  $('.accordion-button').attr('aria-disabled', true).attr('disabled', true);

  $('.accordion-button').first().attr('disabled', false).attr('aria-disabled', false);

  $('.accordion-collapse').removeClass('show');
  $('#collapseOne').addClass('show');

 
//1------------------------------------------
   $('#step1').on('click', function (e) {
    e.preventDefault();
    let isValid = true;

    // Nettoyage des anciens messages
    $('#collapseOne').find('label.error-message').remove();
    $('#collapseOne').find('select').removeClass('is-invalid');

     $('#collapseOne').find('select[required]').each(function () {
      const $select = $(this);
      const selected = $select.val();
      const selectId = $select.attr('id');
      const $label = $('label[for="' + selectId + '"]');

      if (!selected || selected === '') {
        isValid = false;
        $select.addClass('is-invalid');
        $label.after('<label class="error-message">Veuillez sélectionner une option.</label>');
      }
    });

    // Si tout est OK → ouvrir le 2e accordion
    if (isValid) {
      const btn2 = $('.accordion-button.accordion2');
      btn2.attr('aria-disabled', false).attr('disabled', false);
      $('#collapseTwo').collapse('show');
    }
  });
//2-----------------------------------------
  $('#step2').on('click', function (e) {
    e.preventDefault();
    let isValid = true;

    // Nettoyage des anciens messages
    $('#collapseTwo').find('label.error-message').remove();
    $('#collapseTwo').find('input').removeClass('is-invalid');

    // Vérification de tous les champs requis
    $('#collapseTwo').find('input[required]').each(function () {
      const $input = $(this);
      const value = $input.val();
      const type = $input.attr('type');
      const inputId = $input.attr('id');

      // Trouver le <label> associé
      const $label = $('label[for="' + inputId + '"]');

      // Si vide
      if (!value) {
        isValid = false;
        $input.addClass('is-invalid');
        $label.after('<label class="error-message"> Ce champ est requis.</label>');
        return;
      }

      // Si email invalide
      if (type === 'email') {
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailRegex.test(value)) {
          isValid = false;
          $input.addClass('is-invalid');
          $label.after('<label class="error-message"> Adresse email invalide.</label>');
        }
      }
    });

    // Si tout est OK → ouvrir le 2e accordion
    if (isValid) {
      const btn2 = $('.accordion-button.accordion3');
      btn2.attr('aria-disabled', false).attr('disabled', false);
      $('#collapseThree').collapse('show');
    }
  });
//3----------------------------------------
  $('#btn-addPlan').on('click', function (e) {
    e.preventDefault();

    let isValid = true;
    const $lastGroup = $('#collapseThree');
    
    // Nettoyer les messages précédents
    $lastGroup.find('label.error-message').remove();
    $lastGroup.find('input, select').removeClass('is-invalid');

    // Vérification des 3 champs
    $lastGroup.find('input[required]').each(function () {
      if (!$(this).val().trim()) {
        isValid = false;
        const id = $(this).attr('id');
        const $label = $('label[for="' + id + '"]');
        $(this).addClass('is-invalid');
        $label.after('<label class="error-message">Champ requis</label>');
      }
    });

      // Vérifier les champs SELECT requis
    $lastGroup.find('select[required]').each(function () {

       if (!$(this).val().trim()) {
        isValid = false;
        const id = $(this).attr('id');
        const $label = $('label[for="' + id + '"]');
        $(this).addClass('is-invalid');
        $label.after('<label class="error-message">Champ requis</label>');
      }});
 
count = $('#plans-container .listplan').last().attr('index');
    if (!isValid) return;

    count++;

    const newGroup = $(`
      <div class="row listplan" index="${count}">
      <div class="col-xl-4">
							<div class="checkout-page__input-box">
        <label for="longueur${count}">Longueur *</label>
        <input type="number" name="longueur[]" id="longueur${count}" required>
</div></div>
<div class="col-xl-4">
							<div class="checkout-page__input-box">
        <label for="largeur${count}">Largeur *</label>
        <input type="number" name="largeur[]" id="largeur${count}" required>
</div></div>
<div class="col-xl-3">
							<div class="checkout-page__input-box">
        <label for="epaisseur${count}">Épaisseur *</label>
        <select name="epaisseur[]" id="epaisseur${count}" class="selectpicker" aria-label="Epaisseur" required>
									<option value="" selected=""> - </option>
									<option value="20">20</option>
									<option value="30">30</option>
								</select>
</div></div>
<div class="col-xl-1  d-flex justify-content-end">
        <button class="btn-deletePlan" style="margin-top:10px; display:block;align-self:anchor-center;color:red;border:none">X</button>
    </div>
    </div>
    `);

  newGroup.find('select').selectpicker('render');

    $('#plans-container').append(newGroup);
    $('#plans-container').on('click', '.btn-deletePlan', function (e) {
    e.preventDefault();
    $(this).closest('.listplan').remove();
  });
  });
  //----------------------------------------
    $('#step3').on('click', function (e) {
    e.preventDefault();
    let isValid = true;
  const $lastGroup = $('#collapseThree');
    // Nettoyage des anciens messages
    $lastGroup.find('label.error-message').remove();
    $lastGroup.find('input').removeClass('is-invalid');

    $lastGroup.find('input[required]').each(function () {
      if (!$(this).val().trim()) {
        isValid = false;
        const id = $(this).attr('id');
        const $label = $('label[for="' + id + '"]');
        $(this).addClass('is-invalid');
        $label.after('<label class="error-message">Champ requis</label>');
      }
    });

      // Vérifier les champs SELECT requis
    $lastGroup.find('select[required]').each(function () {

       if (!$(this).val().trim()) {
        isValid = false;
        const id = $(this).attr('id');
        const $label = $('label[for="' + id + '"]');
        $(this).addClass('is-invalid');
        $label.after('<label class="error-message">Champ requis</label>');
      }});

    // Si tout est OK → ouvrir le 2e accordion
      if (isValid) {
      const btn2 = $('.accordion-button.accordion4');
      btn2.attr('aria-disabled', false).attr('disabled', false);
      $('#collapseFour').collapse('show');
    }
  });

 //4----------------------------------------
     $('#step4').on('click', function (e) {
    e.preventDefault();
    let isValid = true;
  const $lastGroup = $('#collapseFour');

      const btn2 = $('.accordion-button.accordion5');
      btn2.attr('aria-disabled', false).attr('disabled', false);
      $('#collapseFive').collapse('show');

  });

 $('#chant').on('change', function () {
    var selectedOption = $(this).find('option:selected');
    var imageUrl = selectedOption.data('image'); // lit l'attribut data-image
      imageUrl = 'assets/img/chant/'+imageUrl; // chemin par défaut si pas d'image
 
    $('#chantimg').attr('src', imageUrl); // met à jour le src de l'image
}); 
});

//5----------------------------------------
  $('#btn-addcredence').on('click', function (e) {
    e.preventDefault();

    let isValid = true;
    const $lastGroup = $('#collapseFive');
    
    // Nettoyer les messages précédents
    $lastGroup.find('label.error-message').remove();
    $lastGroup.find('input, select').removeClass('is-invalid');

    // Vérification des 3 champs
    $lastGroup.find('input[required]').each(function () {
      if (!$(this).val().trim()) {
        isValid = false;
        const id = $(this).attr('id');
        const $label = $('label[for="' + id + '"]');
        $(this).addClass('is-invalid');
        $label.after('<label class="error-message">Champ requis</label>');
      }
    });

      // Vérifier les champs SELECT requis
    $lastGroup.find('select[required]').each(function () {

       if (!$(this).val().trim()) {
        isValid = false;
        const id = $(this).attr('id');
        const $label = $('label[for="' + id + '"]');
        $(this).addClass('is-invalid');
        $label.after('<label class="error-message">Champ requis</label>');
      }});
 
count = $('#plans-container .listcredence').last().attr('index');
    if (!isValid) return;

    count++;

    const newGroup = $(`
      <div class="row listcredence" index="${count}">
      <div class="col-xl-4">
							<div class="checkout-page__input-box">
        <label for="cre_longueur${count}">Longueur *</label>
        <input type="number" name="cre_longueur[]" id="cre_longueur${count}" required>
</div></div>
<div class="col-xl-4">
							<div class="checkout-page__input-box">
        <label for="cre_largeur${count}">Largeur *</label>
        <input type="number" name="cre_largeur[]" id="cre_largeur${count}" required>
</div></div>
<div class="col-xl-3">
							<div class="checkout-page__input-box">
        <label for="cre_epaisseur${count}">Épaisseur *</label>
        <select name="cre_epaisseur[]" id="cre_epaisseur${count}" class="selectpicker" aria-label="Epaisseur" required>
									<option value="" selected=""> - </option>
									<option value="20">20</option>
									<option value="30">30</option>
								</select>
</div></div>
<div class="col-xl-1  d-flex justify-content-end">
        <button class="btn-deletecredence" style="margin-top:10px; display:block;align-self:anchor-center;color:red;border:none">X</button>
    </div>
    </div>
    `);

  newGroup.find('select').selectpicker('render');

    $('#credences-container').append(newGroup);
    $('#credences-container').on('click', '.btn-deletecredence', function (e) {
    e.preventDefault();
    $(this).closest('.listcredence').remove();
  });
  });
  //----------------------------------------
    $('#step5').on('click', function (e) {
    e.preventDefault();
    let isValid = true;
  const $lastGroup = $('#collapseFive');
    // Nettoyage des anciens messages
    $lastGroup.find('label.error-message').remove();
    $lastGroup.find('input').removeClass('is-invalid');

    $lastGroup.find('input[required]').each(function () {
      if (!$(this).val().trim()) {
        isValid = false;
        const id = $(this).attr('id');
        const $label = $('label[for="' + id + '"]');
        $(this).addClass('is-invalid');
        $label.after('<label class="error-message">Champ requis</label>');
      }
    });

      // Vérifier les champs SELECT requis
    $lastGroup.find('select[required]').each(function () {

       if (!$(this).val().trim()) {
        isValid = false;
        const id = $(this).attr('id');
        const $label = $('label[for="' + id + '"]');
        $(this).addClass('is-invalid');
        $label.after('<label class="error-message">Champ requis</label>');
      }});

    // Si tout est OK → ouvrir le 2e accordion
      if (isValid) {
      const btn2 = $('.accordion-button.accordion6');
      btn2.attr('aria-disabled', false).attr('disabled', false);
      $('#collapseSix').collapse('show');
    }
  });
 // 6------------------------------------------
   $('#step6').on('click', function (e) {
    e.preventDefault();
      const btn2 = $('.accordion-button.accordion7');
      btn2.attr('aria-disabled', false).attr('disabled', false);
      $('#collapseSeven').collapse('show');

  });

