
@extends('layouts.app')
@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">
                        {{ isset($accessoire) ? 'Modifier Accessoire' : 'Ajout Accessoire' }}
                    </h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="{{ route('admin.accessoires.index') }}" class="btn btn-flex btn-outline btn-color-gray-700 btn-active-color-primary bg-body h-40px fs-7 fw-bold">Liste</a>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
                <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-shield-tick fs-2hx text-success me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-success">Succès</h4>
                        <span>{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-cross-circle fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreur</h4>
                        <span>{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-cross-circle fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreurs de validation</h4>
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            @endif
            
            <form id="kt_ecommerce_category_form" class="form d-flex flex-column flex-lg-row" 
                  action="{{ isset($accessoire) ? route('admin.accessoires.update', $accessoire) : route('admin.accessoires.store') }}" 
                  method="POST" enctype="multipart/form-data">
                @csrf
                @if(isset($accessoire))
                    @method('PUT')
                @endif
                
                <div class="d-flex flex-column gap-7 gap-lg-10 w-100 w-lg-300px mb-7 me-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Photo</h2>
                            </div>
                        </div>

                        <div class="card-body text-center pt-0">
                            <div class="image-input image-input-empty image-input-outline image-input-placeholder mb-3" data-kt-image-input="true">
                                <div class="image-input-wrapper w-150px h-150px" 
                                     style="background-image: url({{ isset($accessoire) && $accessoire->photo ? asset('storage/' . $accessoire->photo) : '' }})"></div>

                                <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Photo obligatoire">
                                    <i class="ki-outline ki-pencil fs-7"></i>
                                    <input type="file" name="photo" accept=".png, .jpg, .jpeg" required="required" />
                                    <input type="hidden" name="avatar_remove" />
                                </label>

                                <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel avatar">
                                    <i class="ki-outline ki-cross fs-2"></i>
                                </span>

                                <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove avatar">
                                    <i class="ki-outline ki-cross fs-2"></i>
                                </span>
                            </div>

                            <div class="text-muted fs-7">Seuls les fichiers *.png, *.jpg et *.jpeg sont acceptés.</div>
                        </div>
                    </div>

                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Status</h2>
                            </div>
                            <div class="card-toolbar">
                                <div class="rounded-circle {{ isset($accessoire) && $accessoire->pub ? 'bg-success' : 'bg-danger' }} w-15px h-15px" id="kt_ecommerce_add_category_status"></div>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <select name="pub" class="form-select mb-2" id="kt_ecommerce_add_category_status_select">
                                <option value="1" {{ isset($accessoire) && $accessoire->pub ? 'selected' : '' }}>Publié</option>
                                <option value="0" {{ isset($accessoire) && !$accessoire->pub ? 'selected' : '' }}>Non publié</option>
                            </select>
                            <div class="text-muted fs-7">Sélectionner le statut de l'accessoire.</div>
                        </div>
                    </div>
                </div>

                <div class="d-flex flex-column flex-row-fluid gap-7 gap-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>General</h2>
                            </div>
                        </div>

                        <div class="card-body pt-0">
                            <div class="mb-10 fv-row">
                                <label class="required form-label">Titre</label>
                                <input type="text" name="titre" class="form-control mb-2" placeholder="Titre" 
                                       value="{{ isset($accessoire) ? $accessoire->titre : old('titre') }}" required />
                                <div class="text-muted fs-7">Ce champs est requis.</div>
                            </div>

                            <div class="mb-10 fv-row">
                                <label class="form-label">Description</label>
                                <textarea name="description" class="form-control mb-2" rows="3" placeholder="Description">{{ isset($accessoire) ? $accessoire->description : old('description') }}</textarea>
                            </div>

                            <div class="mb-10 fv-row">
                                <label class="form-label">Contenu</label>
                                <textarea name="content" class="form-control mb-2" rows="5" placeholder="Contenu">{{ isset($accessoire) ? $accessoire->content : old('content') }}</textarea>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-10 fv-row">
                                        <label class="form-label">Référence</label>
                                        <input type="text" name="ref" class="form-control mb-2" placeholder="Référence" 
                                               value="{{ isset($accessoire) ? $accessoire->ref : old('ref') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-10 fv-row">
                                        <label class="required form-label">Prix</label>
                                        <input type="number" step="0.01" name="prix" class="form-control mb-2" placeholder="Prix" 
                                               value="{{ isset($accessoire) ? $accessoire->prix : old('prix') }}" required />
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-10 fv-row">
                                        <label class="required form-label">Marque</label>
                                        <select name="accessoiremarque_id" class="form-select mb-2" required>
                                            <option value="">Sélectionner une marque</option>
                                            @foreach($accessoiremarques as $marque)
                                                <option value="{{ $marque->id }}" 
                                                    {{ isset($accessoire) && $accessoire->accessoiremarque_id == $marque->id ? 'selected' : '' }}>
                                                    {{ $marque->titre }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-10 fv-row">
                                        <label class="required form-label">Catégorie</label>
                                        <select name="categorieaccessoire_id" class="form-select mb-2" required>
                                            <option value="">Sélectionner une catégorie</option>
                                            @foreach($categorieaccessoires as $categorie)
                                                <option value="{{ $categorie->id }}" 
                                                    {{ isset($accessoire) && $accessoire->categorieaccessoire_id == $categorie->id ? 'selected' : '' }}>
                                                    {{ $categorie->titre }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end">
                        <a href="{{ route('admin.accessoires.index') }}" class="btn btn-light me-5">Annuler</a>
                        <button type="submit" class="btn btn-primary">
                            {{ isset($accessoire) ? 'Modifier' : 'Ajouter' }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

<script>
document.addEventListener('DOMContentLoaded', function() {
    const statusSelect = document.getElementById('kt_ecommerce_add_category_status_select');
    const statusCircle = document.getElementById('kt_ecommerce_add_category_status');
    
    if (statusSelect && statusCircle) {
        // Fonction pour mettre à jour la couleur du cercle
        function updateStatusCircle() {
            const selectedValue = statusSelect.value;
            
            // Retirer les classes existantes
            statusCircle.classList.remove('bg-success', 'bg-danger');
            
            // Ajouter la classe appropriée selon le statut
            if (selectedValue === '1') {
                statusCircle.classList.add('bg-success'); // Vert pour publié
            } else {
                statusCircle.classList.add('bg-danger'); // Rouge pour non publié
            }
        }
        
        // Écouter le changement de sélection
        statusSelect.addEventListener('change', updateStatusCircle);
        
        // Initialiser la couleur au chargement de la page
        updateStatusCircle();
    }
});
</script>
