
@extends('layouts.app')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">
                        {{ isset($blog) ? 'Modifier Blog' : 'Ajout Blog' }}
                    </h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="{{ route('admin.blogs.index') }}" class="btn btn-flex btn-outline btn-color-gray-700 btn-active-color-primary bg-body h-40px fs-7 fw-bold">Liste</a>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
                <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-shield-tick fs-2hx text-success me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-success">Succès</h4>
                        <span>{{ session('success') }}</span>
                    </div>
                </div>
            @endif
            
            @if($errors->any())
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-cross-circle fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreurs de validation</h4>
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            @endif

            <form id="kt_ecommerce_add_category_form" class="form d-flex flex-column flex-lg-row" 
                  action="{{ isset($blog) ? route('admin.blogs.update', $blog) : route('admin.blogs.store') }}" 
                  method="POST" enctype="multipart/form-data">
                @csrf
                @if(isset($blog))
                    @method('PUT')
                @endif
                
                <div class="d-flex flex-column gap-7 gap-lg-10 w-100 w-lg-300px mb-7 me-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Photo</h2>
                            </div>
                        </div>
                        <div class="card-body text-center pt-0">
                            <div class="image-input image-input-empty image-input-outline image-input-placeholder mb-3" data-kt-image-input="true">
                                <div class="image-input-wrapper w-150px h-150px" style="background-image: url({{ isset($blog) && $blog->photo ? asset('storage/' . $blog->photo) : '' }})"></div>
                                <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Photo du blog">
                                    <i class="ki-outline ki-pencil fs-7"></i>
                                    <input type="file" name="photo" accept=".png,.jpg,.jpeg" />
                                    <input type="hidden" name="avatar_remove" />
                                </label>
                                <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Annuler photo">
                                    <i class="ki-outline ki-cross fs-2"></i>
                                </span>
                                <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Effacer photo">
                                    <i class="ki-outline ki-cross fs-2"></i>
                                </span>
                            </div>
                            <div class="text-muted fs-7">Seuls les fichiers *.png, *.jpg et *.jpeg sont acceptés.</div>
                        </div>
                    </div>

                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Status</h2>
                            </div>
                            <div class="card-toolbar">
                                <div class="rounded-circle {{ isset($blog) && $blog->pub ? 'bg-success' : 'bg-danger' }} w-15px h-15px" id="kt_ecommerce_add_category_status"></div>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <select name="pub" class="form-select mb-2" id="kt_ecommerce_add_category_status_select">
                                <option value="1" {{ isset($blog) && $blog->pub ? 'selected' : '' }}>Publié</option>
                                <option value="0" {{ isset($blog) && !$blog->pub ? 'selected' : '' }}>Non publié</option>
                            </select>
                            <div class="text-muted fs-7">Sélectionner le statut du blog.</div>
                        </div>
                    </div>

                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Catégorie</h2>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <select name="categorieblog_id" class="form-select mb-2" required>
                                <option value="">Sélectionner une catégorie</option>
                                @foreach($categorieblogs as $categorie)
                                    <option value="{{ $categorie->id }}" {{ isset($blog) && $blog->categorieblog_id == $categorie->id ? 'selected' : '' }}>
                                        {{ $categorie->titre }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="text-muted fs-7">Catégorie du blog.</div>
                        </div>
                    </div>

                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Ordre</h2>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <input type="number" name="ordre" class="form-control mb-2" placeholder="Ordre d'affichage" 
                                   value="{{ isset($blog) ? $blog->ordre : old('ordre') }}" />
                            <div class="text-muted fs-7">Ordre d'affichage du blog.</div>
                        </div>
                    </div>
                </div>

                <div class="d-flex flex-column flex-row-fluid gap-7 gap-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>General</h2>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <div class="mb-10 fv-row">
                                <label class="required form-label">Titre</label>
                                <input type="text" name="titre" class="form-control mb-2" placeholder="Titre du blog" 
                                       value="{{ isset($blog) ? $blog->titre : old('titre') }}" required />
                                <div class="text-muted fs-7">Ce champs est requis.</div>
                            </div>
                            
                            <div class="mb-10 fv-row">
                                <label class="form-label">Description</label>
                                <textarea name="description" class="form-control mb-2" rows="4" placeholder="Description courte du blog">{{ isset($blog) ? $blog->description : old('description') }}</textarea>
                                <div class="text-muted fs-7">Description courte qui apparaîtra dans les listes.</div>
                            </div>

                            <div class="mb-10 fv-row">
                                <label class="form-label">Contenu</label>
                                <textarea name="contenu" id="kt_docs_tinymce_basic" class="tox-target">{{ isset($blog) ? $blog->contenu : old('contenu') }}</textarea>
                                <div class="text-muted fs-7">Contenu complet de l'article de blog.</div>
                            </div>

                            <div class="mb-10 fv-row">
                                <label class="form-label">Slug</label>
                                <input type="text" name="slug" class="form-control mb-2" placeholder="slug-url-friendly" 
                                       value="{{ isset($blog) ? $blog->slug : old('slug') }}" />
                                <div class="text-muted fs-7">URL conviviale pour le blog (laissez vide pour génération automatique).</div>
                            </div>
                        </div>
                    </div>

                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Meta données SEO</h2>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <div class="mb-10 fv-row">
                                <label class="form-label">Meta Title</label>
                                <input type="text" name="meta_title" class="form-control mb-2" placeholder="Titre pour les moteurs de recherche" 
                                       value="{{ isset($blog) ? $blog->meta_title : old('meta_title') }}" />
                                <div class="text-muted fs-7">Titre optimisé pour le SEO (60 caractères max).</div>
                            </div>

                            <div class="mb-10 fv-row">
                                <label class="form-label">Meta Description</label>
                                <textarea name="meta_description" class="form-control mb-2" rows="3" placeholder="Description pour les moteurs de recherche">{{ isset($blog) ? $blog->meta_description : old('meta_description') }}</textarea>
                                <div class="text-muted fs-7">Description optimisée pour le SEO (160 caractères max).</div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end">
                        <a href="{{ route('admin.blogs.index') }}" class="btn btn-light me-5">Annuler</a>
                        <button type="submit" class="btn btn-primary">
                            {{ isset($blog) ? 'Modifier' : 'Ajouter' }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const statusSelect = document.getElementById('kt_ecommerce_add_category_status_select');
    const statusCircle = document.getElementById('kt_ecommerce_add_category_status');
    
    if (statusSelect && statusCircle) {
        // Fonction pour mettre à jour la couleur du cercle
        function updateStatusCircle() {
            const selectedValue = statusSelect.value;
            
            // Retirer les classes existantes
            statusCircle.classList.remove('bg-success', 'bg-danger');
            
            // Ajouter la classe appropriée selon le statut
            if (selectedValue === '1') {
                statusCircle.classList.add('bg-success'); // Vert pour publié
            } else {
                statusCircle.classList.add('bg-danger'); // Rouge pour non publié
            }
        }
        
        // Écouter le changement de sélection
        statusSelect.addEventListener('change', updateStatusCircle);
        
        // Initialiser la couleur au chargement de la page
        updateStatusCircle();
    }

    // Charger TinyMCE dynamiquement
    if (typeof tinymce === 'undefined') {
        const script = document.createElement('script');
        script.src = "{{ secure_asset('assets/plugins/custom/tinymce/tinymce.bundle.js') }}";
        script.onload = function() {
            initializeTinyMCE();
        };
        document.head.appendChild(script);
    } else {
        initializeTinyMCE();
    }

    function initializeTinyMCE() {
        var options = {
            selector: "#kt_docs_tinymce_basic",
            height: "480",
            menubar: false,
            statusbar: false,
            plugins: [
                "advlist autolink lists link image charmap print preview anchor",
                "searchreplace visualblocks code fullscreen",
                "insertdatetime media table paste code help wordcount"
            ],
            toolbar: "undo redo | formatselect | bold italic backcolor | \
                     alignleft aligncenter alignright alignjustify | \
                     bullist numlist outdent indent | removeformat | help"
        };

        if (typeof KTThemeMode !== 'undefined' && KTThemeMode.getMode() === "dark") {
            options["skin"] = "oxide-dark";
            options["content_css"] = "dark";
        }

        tinymce.init(options);
    }
});
</script>
@endsection
