@extends('layouts.app')
@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">
                        {{ isset($colori) ? 'Modifier Colori' : 'Ajout Colori' }}
                    </h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="{{ route('admin.coloris.index') }}{{ isset($colori) ? '?matiere_id=' . $colori->matiere_id : (isset($selectedMatiereId) ? '?matiere_id=' . $selectedMatiereId : '') }}" class="btn btn-flex btn-outline btn-color-gray-700 btn-active-color-primary bg-body h-40px fs-7 fw-bold">Liste</a>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
                <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-shield-tick fs-2hx text-success me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-success">Succès</h4>
                        <span>{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-information-5 fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreur</h4>
                        <span>{{ $errors->first() }}</span>
                    </div>
                </div>
            @endif

            <form id="kt_ecommerce_category_form" class="form d-flex flex-column flex-lg-row" 
                  action="{{ isset($colori) ? route('admin.coloris.update', $colori) : route('admin.coloris.store') }}" 
                  method="POST" enctype="multipart/form-data">
                @csrf
                @if(isset($colori))
                    @method('PUT')
                @endif

                <div class="d-flex flex-column gap-7 gap-lg-10 w-100 w-lg-300px mb-7 me-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Photo</h2>
                            </div>
                        </div>

                        <div class="card-body text-center pt-0">
                            <div class="image-input image-input-empty image-input-outline image-input-placeholder mb-3" data-kt-image-input="true">
                                <div class="image-input-wrapper w-150px h-150px" 
                                     style="background-image: url({{ isset($colori) && $colori->photo ? asset('storage/' . $colori->photo) : '' }})"></div>

                                <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Photo">
                                    <i class="ki-outline ki-pencil fs-7"></i>
                                    <input type="file" name="photo" accept=".png, .jpg, .jpeg" {{ !isset($colori) ? 'required' : '' }} />
                                    <input type="hidden" name="avatar_remove" />
                                </label>

                                <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="annuler photo">
                                    <i class="ki-outline ki-cross fs-2"></i>
                                </span>

                                <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove photo">
                                    <i class="ki-outline ki-cross fs-2"></i>
                                </span>
                            </div>

                            <div class="text-muted fs-7">Seuls les fichiers *.png, *.jpg et *.jpeg sont acceptés.</div>
                        </div>
                    </div>

                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Status</h2>
                            </div>
                            <div class="card-toolbar">
                                <div class="rounded-circle {{ isset($colori) && $colori->pub ? 'bg-success' : 'bg-danger' }} w-15px h-15px" id="kt_ecommerce_add_category_status"></div>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <select name="pub" class="form-select mb-2" id="kt_ecommerce_add_category_status_select">
                                <option value="1" {{ isset($colori) && $colori->pub ? 'selected' : '' }}>Publié</option>
                                <option value="0" {{ isset($colori) && !$colori->pub ? 'selected' : '' }}>Non publié</option>
                            </select>
                            <div class="text-muted fs-7">Sélectionner le statut du coloris.</div>
                        </div>
                    </div>
                </div>

                <div class="d-flex flex-column flex-row-fluid gap-7 gap-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>General</h2>
                            </div>
                        </div>

                        <div class="card-body pt-0">
                            <div class="mb-10 fv-row">
                                <label class="required form-label">Titre</label>
                                <input type="text" name="titre" class="form-control mb-2" placeholder="Titre" 
                                       value="{{ isset($colori) ? $colori->titre : old('titre') }}" required />
                                <div class="text-muted fs-7">Ce champs est requis.</div>
                            </div>

                            <div class="mb-10 fv-row">
                                <label class="required form-label">Description</label>
                                <textarea name="description" class="form-control mb-2" rows="4" placeholder="Description du coloris" required>{{ isset($colori) ? $colori->description : old('description') }}</textarea>
                                <div class="text-muted fs-7">Ce champs est requis.</div>
                            </div>

                            <div class="mb-10 fv-row">
                                <label for="images" class="form-label">Télécharger des images</label>
                                <input class="form-control" type="file" id="images" name="images[]" multiple accept="image/*">
                                <div class="text-muted fs-7">Sélectionnez plusieurs images pour le coloris.</div>

                                <!-- Zone de prévisualisation -->
                                <div id="preview" class="row g-2 mt-2"></div>

                                @if(isset($colori) && $colori->photocoloris->count() > 0)
                                    <div class="mt-4">
                                        <label class="form-label">Images existantes</label>
                                        <div class="row g-2">
                                            @foreach($colori->photocoloris as $photo)
                                                <div class="col-2">
                                                    <div class="card">
                                                        <img src="{{ asset('storage/' . $photo->photo) }}" class="card-img-top" style="height: 100px; text-align:center;  object-fit: cover;">
                                                        <div class="card-body p-2">
                                                            <button type="button" class="btn btn-sm btn-danger w-100" onclick="deletePhoto({{ $photo->id }})">Supprimer</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>

                            @if(isset($selectedMatiereId) && $selectedMatiereId && !isset($colori))
                                <input type="hidden" name="matiere_id" value="{{ $selectedMatiereId }}" />
                                <div class="mb-10 fv-row">
                                    <label class="form-label">Matière sélectionnée</label>
                                    <div class="form-control mb-2 bg-light-primary">{{ $selectedMatiere->titre }}</div>
                                    <div class="text-muted fs-7">La matière a été automatiquement sélectionnée.</div>
                                </div>
                            @else
                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Matière</label>
                                    <select name="matiere_id" class="form-select mb-2" required>
                                        <option value="">Sélectionner une matière</option>
                                        @foreach($matieres as $matiere)
                                            <option value="{{ $matiere->id }}" {{ old('matiere_id', $colori->matiere_id ?? $selectedMatiereId ?? '') == $matiere->id ? 'selected' : '' }}>
                                                {{ $matiere->titre }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <div class="text-muted fs-7">Sélectionnez la matière associée.</div>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Meta Options</h2>
                            </div>
                        </div>

                        <div class="card-body pt-0">
                            <div class="mb-10">
                                <label class="form-label">URL - Slug</label>
                                <input type="text" class="form-control mb-2" name="slug" placeholder="url" 
                                       value="{{ isset($colori) ? $colori->slug : old('slug') }}" />
                            </div>

                            <div class="mb-10">
                                <label class="form-label">Meta Title</label>
                                <input type="text" name="meta_title" class="form-control mb-2" maxlength="255" 
                                       value="{{ isset($colori) ? $colori->meta_title : old('meta_title') }}">
                            </div>

                            <div class="mb-10">
                                <label class="form-label">Meta Description</label>
                                <textarea name="meta_description" class="form-control mb-2" rows="3">{{ isset($colori) ? $colori->meta_description : old('meta_description') }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="card card-flush py-4">

                        <div class="card-header">
                            <div class="card-title">
                                <h2>Tarification</h2>
                            </div>
                        </div>


                        <div class="card-body pt-0">




                            <div class="mb-10">
                                <div id="tarification-container">
                                    @if(isset($colori) && $colori->prixcoloris->count() > 0)
                                        @foreach($colori->prixcoloris as $prix)
                                            <div class="tarification-item mt-5" data-prix-id="{{ $prix->id }}">
                                                <div class="form-group row">
                                                    <div class="col-md-3">
                                                        <label class="form-label">Finition:</label>
                                                        <select name="tarifs[{{ $loop->index }}][finition_id]" class="form-select finition-select" data-hide-search="true" data-control="select2">
                                                            <option value="">Sélectionner une finition</option>
                                                            @foreach($finitions as $finition)
                                                                <option value="{{ $finition->id }}" {{ $prix->finition_id == $finition->id ? 'selected' : '' }}>{{ $finition->titre }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="form-label">Epaisseur:</label>
                                                        <select name="tarifs[{{ $loop->index }}][epaisseur_id]" class="form-select epaisseur-select" data-hide-search="true" data-control="select2">
                                                            <option value="">Sélectionner une épaisseur</option>
                                                            @foreach($epaisseurs as $epaisseur)
                                                                <option value="{{ $epaisseur->id }}" {{ $prix->epaisseur_id == $epaisseur->id ? 'selected' : '' }}>{{ $epaisseur->titre }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="form-label">Prix m2:</label>
                                                        <input name="tarifs[{{ $loop->index }}][prix]" type="number" step="0.01" class="form-control prix-input" value="{{ $prix->prix }}" />
                                                        <input type="hidden" name="tarifs[{{ $loop->index }}][prix_id]" value="{{ $prix->id }}" />
                                                    </div>
                                                    <div class="col-md-3">
                                                        <button type="button" class="btn btn-sm btn-light-danger mt-3 mt-md-8 delete-tarif-existing" data-prix-id="{{ $prix->id }}">
                                                            <i class="ki-duotone ki-trash fs-5"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span><span class="path5"></span></i>
                                                            Supprimer
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>

                                <div class="form-group mt-5">
                                    <button type="button" id="add-tarif-btn" class="btn btn-light-primary">
                                        <i class="ki-duotone ki-plus fs-3"></i>
                                        Ajouter un tarif
                                    </button>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="d-flex justify-content-end">
                        <a href="{{ route('admin.coloris.index') }}{{ isset($colori) ? '?matiere_id=' . $colori->matiere_id : (isset($selectedMatiereId) ? '?matiere_id=' . $selectedMatiereId : '') }}" class="btn btn-light me-5">Annuler</a>
                        <button type="submit" class="btn btn-primary">
                            {{ isset($colori) ? 'Modifier' : 'Ajouter' }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script>
let selectedFiles = [];
let tarifsData = @json(isset($colori) ? $colori->prixcoloris : []);
let tarifCounter = tarifsData.length;

// Configuration d'Axios avec CSRF token
axios.defaults.headers.common['X-CSRF-TOKEN'] = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

document.getElementById('images').addEventListener('change', function(e) {
    const preview = document.getElementById('preview');
    const newFiles = Array.from(e.target.files);

    // Compter les photos existantes
    const photosExistantes = document.querySelectorAll('.card-img-top').length - 1; // -1 pour exclure la photo principale
    const totalPhotos = photosExistantes + selectedFiles.length + newFiles.length;

    // Vérifier le nombre maximum total de photos
    if (totalPhotos > 10) {
        alert(`Le nombre total de photos ne peut pas dépasser 10. Vous avez actuellement ${photosExistantes} photos. Vous pouvez ajouter au maximum ${10 - photosExistantes - selectedFiles.length} nouvelles photos.`);
        e.target.value = ''; // Réinitialiser l'input
        return;
    }

    // Vérifier le nombre maximum de fichiers sélectionnés
    if (newFiles.length > 10) {
        alert('Vous pouvez télécharger un maximum de 10 images à la fois.');
        e.target.value = ''; // Réinitialiser l'input
        return;
    }

    // Ajouter les nouveaux fichiers à la liste
    newFiles.forEach(file => {
        if (file.type.startsWith('image/')) {
            selectedFiles.push(file);
        }
    });

    // Mettre à jour la prévisualisation
    updatePreview();
});

function updatePreview() {
    const preview = document.getElementById('preview');
    preview.innerHTML = '';

    selectedFiles.forEach((file, index) => {
        const reader = new FileReader();
        reader.onload = function(e) {
            const col = document.createElement('div');
            col.className = 'col-2 position-relative';
            col.innerHTML = `
                <div class="card">
                    <div class="position-relative">
                        <img src="${e.target.result}" class="card-img-top" style="height: 100px; text-align:center; object-fit: cover;">
                        <button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0 m-1 rounded-circle" 
                                style="width: 25px; height: 25px; padding: 0; line-height: 1;" 
                                onclick="removePreviewImage(${index})" 
                                title="Supprimer cette image">
                            <i class="ki-outline ki-cross fs-6"></i>
                        </button>
                    </div>
                    <div class="card-body p-2">
                        <small class="text-muted">${file.name}</small>
                    </div>
                </div>
            `;
            preview.appendChild(col);
        };
        reader.readAsDataURL(file);
    });

    // Mettre à jour l'input file avec les fichiers sélectionnés
    updateFileInput();
}

function removePreviewImage(index) {
    selectedFiles.splice(index, 1);
    updatePreview();
}

function updateFileInput() {
    const input = document.getElementById('images');
    const dt = new DataTransfer();

    selectedFiles.forEach(file => {
        dt.items.add(file);
    });

    input.files = dt.files;
}

// S'assurer que les fichiers sont attachés avant la soumission
document.getElementById('kt_ecommerce_category_form').addEventListener('submit', function(e) {
    // Mettre à jour une dernière fois l'input avant la soumission
    updateFileInput();
});

function deletePhoto(photoId) {
    if (confirm('Voulez-vous vraiment supprimer cette image ?')) {
        axios.delete(`/admin/photocoloris/${photoId}`)
            .then(response => {
                if (response.data.success) {
                    location.reload();
                } else {
                    alert('Erreur lors de la suppression de l\'image');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Erreur lors de la suppression de l\'image');
            });
    }
}

// Gestion des tarifications
document.getElementById('add-tarif-btn').addEventListener('click', function() {
    addTarificationRow();
});

function addTarificationRow() {
    const container = document.getElementById('tarification-container');

    const newRow = document.createElement('div');
    newRow.className = 'tarification-item mt-5';
    newRow.innerHTML = `
        <div class="form-group row">
            <div class="col-md-3">
                <label class="form-label">Finition:</label>
                <select name="tarifs[${tarifCounter}][finition_id]" class="form-select finition-select" data-hide-search="true" data-control="select2">
                    <option value="">Sélectionner une finition</option>
                    @foreach($finitions as $finition)
                        <option value="{{ $finition->id }}">{{ $finition->titre }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Épaisseur:</label>
                <select name="tarifs[${tarifCounter}][epaisseur_id]" class="form-select epaisseur-select" data-hide-search="true" data-control="select2">
                    <option value="">Sélectionner une épaisseur</option>
                    @foreach($epaisseurs as $epaisseur)
                        <option value="{{ $epaisseur->id }}">{{ $epaisseur->titre }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Prix m2:</label>
                <input name="tarifs[${tarifCounter}][prix]" type="number" step="0.01" class="form-control prix-input" />
            </div>
            <div class="col-md-3">
                <button type="button" class="btn btn-sm btn-light-danger mt-3 mt-md-8 remove-tarif-row">
                    <i class="ki-duotone ki-trash fs-5"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span><span class="path5"></span></i>
                    Supprimer
                </button>
            </div>
        </div>
    `;

    container.appendChild(newRow);

    // Initialiser Select2 pour les nouveaux selects
    $(newRow).find('select[data-control="select2"]').select2({
        minimumResultsForSearch: Infinity
    });

    // Ajouter les événements de validation pour les nouveaux selects
    $(newRow).find('.finition-select, .epaisseur-select').on('change', validateTarificationCombination);

    tarifCounter++;
}

// Fonction pour valider les combinaisons de tarification
function validateTarificationCombination() {
    const container = document.getElementById('tarification-container');
    const items = container.querySelectorAll('.tarification-item');
    const combinations = [];
    let hasDuplicate = false;

    items.forEach((item, index) => {
        const finitionSelect = item.querySelector('.finition-select');
        const epaisseurSelect = item.querySelector('.epaisseur-select');

        if (finitionSelect && epaisseurSelect) {
            const finitionId = finitionSelect.value;
            const epaisseurId = epaisseurSelect.value;

            if (finitionId && epaisseurId) {
                const combination = `${finitionId}-${epaisseurId}`;

                if (combinations.includes(combination)) {
                    // Marquer comme erreur
                    finitionSelect.classList.add('is-invalid');
                    epaisseurSelect.classList.add('is-invalid');
                    hasDuplicate = true;
                } else {
                    // Retirer les classes d'erreur
                    finitionSelect.classList.remove('is-invalid');
                    epaisseurSelect.classList.remove('is-invalid');
                    combinations.push(combination);
                }
            }
        }
    });

    // Afficher/masquer le message d'erreur
    let errorMsg = document.getElementById('tarif-error-msg');
    if (hasDuplicate) {
        if (!errorMsg) {
            errorMsg = document.createElement('div');
            errorMsg.id = 'tarif-error-msg';
            errorMsg.className = 'alert alert-danger mt-3';
            errorMsg.textContent = 'Une combinaison finition/épaisseur ne peut pas être dupliquée.';
            container.appendChild(errorMsg);
        }
    } else {
        if (errorMsg) {
            errorMsg.remove();
        }
    }

    return !hasDuplicate;
}


</script>
@endsection

<script>
document.addEventListener('DOMContentLoaded', function() {
    const statusSelect = document.getElementById('kt_ecommerce_add_category_status_select');
    const statusCircle = document.getElementById('kt_ecommerce_add_category_status');
    
    if (statusSelect && statusCircle) {
        // Fonction pour mettre à jour la couleur du cercle
        function updateStatusCircle() {
            const selectedValue = statusSelect.value;
            
            // Retirer les classes existantes
            statusCircle.classList.remove('bg-success', 'bg-danger');
            
            // Ajouter la classe appropriée selon le statut
            if (selectedValue === '1') {
                statusCircle.classList.add('bg-success'); // Vert pour publié
            } else {
                statusCircle.classList.add('bg-danger'); // Rouge pour non publié
            }
        }
        
        // Écouter le changement de sélection
        statusSelect.addEventListener('change', updateStatusCircle);
        
        // Initialiser la couleur au chargement de la page
        updateStatusCircle();
    }
});
</script>

@section('scripts')
<script>
    // Initialiser les événements
    $(document).ready(function() {
        // Autres initialisations...
        initializeEvents();
    });

    function initializeEvents() {
    // Event delegation pour les boutons de suppression de tarifs existants
    $(document).on('click', '.delete-tarif-existing', function() {
        const prixId = $(this).data('prix-id');
        if (!prixId) {
            alert('ID du tarif introuvable');
            return;
        }

        if (confirm('Êtes-vous sûr de vouloir supprimer ce tarif ?')) {
            axios.delete(`/admin/prixcoloris/${prixId}`)
                .then(response => {
                    $(this).closest('.tarification-item').remove();
                    validateTarificationCombination();
                })
                .catch(error => {
                    console.log('Error:', error);
                    alert('Erreur lors de la suppression');
                });
        }
    });

    // Event delegation pour les boutons de suppression dynamiques
    $(document).on('click', '.remove-tarif-row', function() {
        $(this).closest('.tarification-item').remove();
        validateTarificationCombination();
    });

    // Ajouter validation aux selects existants
    $('.finition-select, .epaisseur-select').on('change', validateTarificationCombination);

    // Validation lors de la soumission du formulaire
    $('form').on('submit', function(e) {
        if (!validateTarificationCombination()) {
            e.preventDefault();
            alert('Veuillez corriger les combinaisons finition/épaisseur dupliquées avant de soumettre le formulaire.');
            return false;
        }
    });
}
</script>
<script src="/assets/plugins/custom/formrepeater/formrepeater.bundle.js"></script>
<script src="/assets/js/detail.js"></script>
<script>
    $(document).ready(function() {
        $('.finition-select').on('change', function() {
            const finitionId = $(this).val();
            const coloriId = "{{ isset($colori) ? $colori->id : null }}";

            if (!coloriId) {
                console.error('Colori ID is not available.');
                return;
            }
            // URL de la requête
            const url = `{{ url('/admin/finitions/by-coloris') }}/${coloriId}`;
            console.log('URL de la requête finitions:', url);

            axios.get(url, {
                params: {
                    finition_id: finitionId
                }
            })
            .then(response => {
                let options = '<option value="">Sélectionner une finition</option>';
                response.data.forEach(finition => {
                    options += `<option value="${finition.id}">${finition.titre}</option>`;
                });
                $('.finition-select').html(options);
            })
            .catch(error => {
                console.error('Error fetching finitions:', error);
            });
        });

        $('.epaisseur-select').on('change', function() {
            const epaisseurId = $(this).val();
            const coloriId = "{{ isset($colori) ? $colori->id : null }}";
            const finitionId = $(this).closest('.tarification-item').find('.finition-select').val();

            if (!coloriId || !finitionId) {
                console.error('Colori ID or Finition ID is not available.');
                return;
            }
              // URL de la requête
            const url = `{{ url('/admin/epaisseurs/by-coloris-finition') }}/${coloriId}/${finitionId}`;
            console.log('URL de la requête épaisseurs:', url);

            axios.get(url, {
                params: {
                    epaisseur_id: epaisseurId
                }
            })
            .then(response => {
                let options = '<option value="">Sélectionner une épaisseur</option>';
                response.data.forEach(epaisseur => {
                    options += `<option value="${epaisseur.id}">${epaisseur.titre}</option>`;
                });
                $('.epaisseur-select').html(options);
            })
            .catch(error => {
                console.error('Error fetching epaisseurs:', error);
            });
        });
    });
</script>
@endsection