
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Devis {{ $devi->id }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #2E7D32;
            padding-bottom: 20px;
            position: relative;
        }
        .header .logo {
            max-height: 60px;
            margin-bottom: 10px;
        }
        .header h1 {
            color: #2E7D32;
            font-size: 24px;
            margin: 0;
        }
        .header h2 {
            color: #4CAF50;
            font-size: 18px;
            margin: 5px 0;
        }
        .company-info {
            text-align: center;
            margin-bottom: 20px;
            font-size: 10px;
        }
        .devis-info {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }
        .client-info, .devis-details {
            display: table-cell;
            width: 50%;
            vertical-align: top;
            padding: 0 10px;
        }
        .client-info {
            border-right: 1px solid #ddd;
        }
        .info-box {
            border: 1px solid #ddd;
            padding: 15px;
            margin-bottom: 10px;
            background-color: #f9f9f9;
        }
        .info-box h3 {
            margin: 0 0 10px 0;
            color: #2E7D32;
            font-size: 14px;
            border-bottom: 1px solid #4CAF50;
            padding-bottom: 5px;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .table th {
            background-color: #2E7D32;
            color: white;
            font-weight: bold;
        }
        .table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .table .text-right {
            text-align: right;
        }
        .total-section {
            margin-top: 20px;
            text-align: right;
        }
        .total-box {
            display: inline-block;
            border: 2px solid #2E7D32;
            padding: 15px;
            background-color: #f0f0f0;
        }
        .total-box .total-ht {
            font-size: 14px;
            margin-bottom: 5px;
        }
        .total-box .total-ttc {
            font-size: 16px;
            font-weight: bold;
            color: #2E7D32;
        }
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            font-size: 10px;
            text-align: center;
        }
        .material-info {
            background-color: #f5f5f5;
            padding: 10px;
            margin: 10px 0;
            border-left: 4px solid #4CAF50;
        }
    </style>
</head>
<body>
    <div class="header">
        @php
            $logoPath = public_path('frontassets/img/logo_eco_granit.png');
            if (!file_exists($logoPath)) {
                $logoPath = public_path('assets/media/logos/default.svg');
            }
        @endphp
        @if(file_exists($logoPath))
            <img src="{{ $logoPath }}" alt="ECOGRANIT Logo" class="logo">
        @else
            <div style="height: 60px; display: flex; align-items: center; justify-content: center; background: #f0f0f0; margin-bottom: 10px;">
                <span style="font-weight: bold; color: #666;">ECOGRANIT</span>
            </div>
        @endif
        <h1>ECOGRANIT</h1>
        <h2>DEVIS N° {{ $devi->id }}</h2>
    </div>

    <div class="company-info">
        <p><strong>ECOGRANIT</strong> - Plans de travail sur mesure<br>
        Adresse de l'entreprise - Téléphone - Email<br>
        SIRET: 000 000 000 00000 - TVA: FR00000000000</p>
    </div>

    <div class="devis-info">
        <div class="client-info">
            <div class="info-box">
                <h3>INFORMATIONS CLIENT</h3>
                <p><strong>{{ $devi->client->prenom }} {{ $devi->client->nom }}</strong></p>
                <p>{{ $devi->client->adresse }}</p>
                <p>{{ $devi->client->code_postal }} {{ $devi->client->ville }}</p>
                <p>Tél: {{ $devi->client->telephone }}</p>
                <p>Email: {{ $devi->client->email }}</p>
            </div>
        </div>
        
        <div class="devis-details">
            <div class="info-box">
                <h3>DÉTAILS DU DEVIS</h3>
                <p><strong>Date:</strong> {{ $dateGeneration }}</p>
                <p><strong>Validité:</strong> 30 jours</p>
                <p><strong>TVA:</strong> {{ $devi->tva }}%</p>
            </div>
        </div>
    </div>

    <div class="material-info">
        <h3>MATÉRIAUX SÉLECTIONNÉS</h3>
        <p><strong>Matière:</strong> {{ $devi->matiere->titre }}</p>
        <p><strong>Coloris:</strong> {{ $devi->colori->titre }}</p>
        <p><strong>Finition:</strong> {{ $devi->finition->titre }}</p>
        <p><strong>Bordure:</strong> {{ $devi->bordure->titre ?? 'Standard' }}</p>
    </div>

    @if($devi->prixcoloris->count() > 0)
    <h3>PLANS DE TRAVAIL ET CRÉDENCES</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Type</th>
                <th>Longueur (mm)</th>
                <th>Largeur (mm)</th>
                <th>Épaisseur</th>
                <th>Surface (m²)</th>
                <th class="text-right">Prix unitaire</th>
                <th class="text-right">Montant</th>
            </tr>
        </thead>
        <tbody>
            @foreach($devi->prixcoloris as $item)
            <tr>
                <td>{{ $item->type == 'pldt' ? 'Plan de travail' : 'Crédence' }}</td>
                <td>{{ $item->longeur }}</td>
                <td>{{ $item->largeur }}</td>
                <td>{{ $item->prixcolori->epaisseur->titre ?? 'N/A' }}</td>
                <td>{{ number_format(($item->longeur / 1000) * ($item->largeur / 1000), 2) }}</td>
                <td class="text-right">{{ number_format(($item->prixcolori->prix ?? 0) * (1 + ($devi->addperc / 100)), 2) }}€/m²</td>
                <td class="text-right">{{ number_format($item->montant, 2) }}€</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif

    @if($devi->optionsdecoupes->count() > 0)
    <h3>OPTIONS DE DÉCOUPE</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Option</th>
                <th>Quantité</th>
                <th class="text-right">Prix unitaire</th>
                <th class="text-right">Montant</th>
            </tr>
        </thead>
        <tbody>
            @foreach($devi->optionsdecoupes as $option)
            <tr>
                <td>{{ $option->optionsdecoupe->titre }}</td>
                <td>{{ $option->quantite }}</td>
                <td class="text-right">{{ number_format($option->prixu * (1 + ($devi->addperc / 100)), 2) }}€</td>
                <td class="text-right">{{ number_format($option->montant, 2) }}€</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif

    @if($devi->services->count() > 0)
    <h3>SERVICES</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Service</th>
                <th class="text-right">Prix</th>
            </tr>
        </thead>
        <tbody>
            @foreach($devi->services as $service)
            <tr>
                <td>{{ $service->service->titre }}</td>
                <td class="text-right">{{ number_format($service->devis_prix, 2) }}€</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif

    <div class="total-section">
        <div class="total-box">
            <div class="total-ht">Total HT: {{ number_format($devi->total_ht, 2) }}€</div>
            <div>TVA ({{ $devi->tva }}%): {{ number_format($devi->total_ht * ($devi->tva / 100), 2) }}€</div>
            <div class="total-ttc">Total TTC: {{ number_format($totalTTC, 2) }}€</div>
        </div>
    </div>

    <div class="footer">
        <p>Ce devis est valable 30 jours à compter de sa date d'émission.</p>
        <p>Conditions de paiement: Acompte de 50% à la commande, solde à la livraison.</p>
        <p>Délai de fabrication: 2 à 3 semaines après validation du devis.</p>
    </div>
</body>
</html>
