
@extends('layouts.app')
@section('content')

<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Gestion des épaisseurs</h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>	
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="{{ route('admin.epaisseurs.create') }}" class="btn btn-flex btn-primary h-40px fs-7 fw-bold">Ajout</a>
                </div>
            </div>
        </div>
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="card card-flush">
                <div class="card-body pt-0">										
                    <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_ecommerce_category_table">
                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">
                                <th width="15%" class="min-w-100px">Photo</th>
                                <th width="55%" class="min-w-410px">Titre</th>
                                <th width="15%" class="max-w-70px">Ordre</th>
                                <th width="15%" class="text-end max-w-70px">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="fw-semibold text-gray-600">
                            @foreach($epaisseurs as $epaisseur)
                            <tr>
                                <td>
                                    @if($epaisseur->photo)
                                        <img src="{{ asset('storage/' . $epaisseur->photo) }}" alt="Photo" class="w-50px h-50px rounded">
                                    @else
                                        <span class="text-muted">Aucune photo</span>
                                    @endif
                                </td>
                                <td>{{ $epaisseur->titre }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="d-flex">
                                            @if($epaisseur->ordre < $epaisseurs->max('ordre'))
                                            <form action="{{ route('admin.epaisseurs.moveUp', $epaisseur) }}" method="POST" class="me-1">
                                                @csrf
                                                <button type="submit" class="btn btn-icon btn-active-light-primary w-20px h-20px" data-bs-toggle="tooltip" title="Déplacer vers le haut">
                                                    <i class="ki-outline ki-arrow-up fs-6"></i>
                                                </button>
                                            </form>
                                            @else
                                            <div class="me-1" style="width: 20px;"></div>
                                            @endif
                                            @if($epaisseur->ordre > $epaisseurs->min('ordre'))
                                            <form action="{{ route('admin.epaisseurs.moveDown', $epaisseur) }}" method="POST">
                                                @csrf
                                                <button type="submit" class="btn btn-icon btn-active-light-primary w-20px h-20px" data-bs-toggle="tooltip" title="Déplacer vers le bas">
                                                    <i class="ki-outline ki-arrow-down fs-6"></i>
                                                </button>
                                            </form>
                                            @else
                                            <div style="width: 20px;"></div>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex my-3 ms-9">
                                        <div class="ms-auto">
                                            <a href="{{ route('admin.epaisseurs.toggle-publication', $epaisseur) }}" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3" data-bs-toggle="tooltip" title="{{ $epaisseur->pub ? 'Dépublier' : 'Publier' }}">
                                                <i style="color:{{ $epaisseur->pub ? 'green' : 'red' }}" class="ki-outline {{ $epaisseur->pub ? 'ki-check' : 'ki-cross' }} fs-1"></i>
                                            </a>
                                            <a href="{{ route('admin.epaisseurs.edit', $epaisseur) }}" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3">
                                                <span data-bs-toggle="tooltip" data-bs-trigger="hover" title="Edit">
                                                    <i class="ki-outline text-warning ki-pencil fs-3"></i>
                                                </span>
                                            </a>
                                            <form action="{{ route('admin.epaisseurs.destroy', $epaisseur) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-icon btn-active-light-primary w-30px h-30px" data-bs-toggle="tooltip" title="Supression" onclick="return confirm('Voulez-vous continue la supression ?')">
                                                    <i class="ki-outline text-danger ki-trash fs-3"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $epaisseurs->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
