
@extends('layouts.app')

@section('content')

<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Changer le mot de passe</h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('admin.dashboard') }}" class="text-muted text-hover-primary">Tableau de bord</a>
                        </li>
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-500 w-5px h-2px"></span>
                        </li>
                        <li class="breadcrumb-item text-muted">Changer le mot de passe</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">

            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8">

                    @if(session('success'))
                        <div class="alert alert-success mb-5">
                            <div class="alert-text">{{ session('success') }}</div>
                        </div>
                    @endif

                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Modifier votre mot de passe</h2>
                            </div>
                        </div>

                        <form method="POST" action="{{ route('password.update') }}" class="form">
                            @csrf
                            @method('PUT')

                            <div class="card-body">

                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Mot de passe actuel</label>
                                    <input type="password" 
                                           name="current_password" 
                                           class="form-control mb-2 @error('current_password') is-invalid @enderror" 
                                           placeholder="Entrez votre mot de passe actuel"
                                           autocomplete="current-password" />
                                    @error('current_password')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-10 fv-row" data-kt-password-meter="true">
                                    <div class="mb-1">
                                        <label class="required form-label fw-semibold text-gray-900 fs-6">Nouveau mot de passe</label>
                                        <div class="position-relative mb-3">
                                            <input type="password" 
                                                   name="password" 
                                                   class="form-control bg-transparent @error('password') is-invalid @enderror" 
                                                   placeholder="Nouveau mot de passe"
                                                   autocomplete="new-password" />
                                            <span class="btn btn-sm btn-icon position-absolute translate-middle top-50 end-0 me-n2" data-kt-password-meter-control="visibility">
                                                <i class="ki-outline ki-eye-slash fs-2"></i>
                                                <i class="ki-outline ki-eye fs-2 d-none"></i>
                                            </span>
                                        </div>
                                        @error('password')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                        <div class="d-flex align-items-center mb-3" data-kt-password-meter-control="highlight">
                                            <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
                                            <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
                                            <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
                                            <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px"></div>
                                        </div>
                                    </div>
                                    <div class="text-muted">
                                        Utilisez 8 caractères ou plus avec un mélange de lettres, chiffres et symboles.
                                    </div>
                                </div>

                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Confirmer le nouveau mot de passe</label>
                                    <input type="password" 
                                           name="password_confirmation" 
                                           class="form-control mb-2 @error('password_confirmation') is-invalid @enderror" 
                                           placeholder="Confirmez votre nouveau mot de passe"
                                           autocomplete="new-password" />
                                    @error('password_confirmation')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                            </div>

                            <div class="card-footer d-flex justify-content-end py-6 px-9">
                                <a href="{{ route('admin.dashboard') }}" class="btn btn-light btn-active-light-primary me-2">Annuler</a>
                                <button type="submit" class="btn btn-primary">
                                    <span class="indicator-label">Modifier le mot de passe</span>
                                    <span class="indicator-progress">Veuillez patienter... 
                                        <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                    </span>
                                </button>
                            </div>

                        </form>
                    </div>

                </div>
            </div>

        </div>
    </div>
</div>

@endsection
