
@extends('layouts.app')

@section('title', 'Gestion des Permissions')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                <h1 class="page-heading d-flex text-gray-900 fw-bold fs-3 flex-column justify-content-center my-0">Gestion des Permissions</h1>
            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">
                <a href="{{ route('admin.permissions.create') }}" class="btn btn-sm fw-bold btn-primary">
                    <i class="ki-outline ki-plus fs-2"></i>Nouvelle Permission
                </a>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">

            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="card">
                <div class="card-body py-4">
                    <div class="table-responsive">
                        <table class="table align-middle table-row-dashed fs-6 gy-5">
                            <thead>
                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                    <th class="min-w-125px">Permission</th>
                                    <th class="min-w-125px">Nom technique</th>
                                    <th class="min-w-100px">Catégorie</th>
                                    <th class="min-w-100px">Rôles</th>
                                    <th class="min-w-100px">Statut</th>
                                    <th class="text-end min-w-100px">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-semibold">
                                @foreach($permissions as $permission)
                                <tr>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="text-gray-800 fw-bold">{{ $permission->display_name }}</span>
                                            @if($permission->description)
                                                <span class="text-muted fs-7">{{ $permission->description }}</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-light-primary">{{ $permission->name }}</span>
                                    </td>
                                    <td>
                                        <span class="badge badge-light-info">{{ $permission->category }}</span>
                                    </td>
                                    <td>
                                        <span class="badge badge-light-warning">{{ $permission->roles->count() }} rôles</span>
                                    </td>
                                    <td>
                                        @if($permission->is_active)
                                            <span class="badge badge-light-success">Active</span>
                                        @else
                                            <span class="badge badge-light-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.permissions.edit', $permission) }}" class="btn btn-sm btn-light-primary">
                                                <i class="ki-outline ki-pencil fs-7"></i>
                                            </a>
                                            <a href="{{ route('admin.permissions.toggle-status', $permission) }}" class="btn btn-sm btn-light-warning">
                                                <i class="ki-outline ki-switch fs-7"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    {{ $permissions->onEachSide(1)->links('custom-pagination') }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
