
@extends('layouts.app')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">
                        {{ isset($prixcolori) ? 'Modification' : 'Ajout' }} tarification
                    </h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('admin.prixcoloris.index') }}" class="text-muted text-hover-primary">Gestion des tarifications</a>
                        </li>
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-500 w-5px h-2px"></span>
                        </li>
                        <li class="breadcrumb-item text-muted">{{ isset($prixcolori) ? 'Modification' : 'Ajout' }}</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="{{ route('admin.prixcoloris.index') }}" class="btn btn-flex btn-outline btn-color-gray-700 btn-active-color-primary bg-body h-40px fs-7 fw-bold">Retour</a>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if($errors->any())
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-information-5 fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreur</h4>
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            @endif

            <form id="kt_ecommerce_category_form" class="form d-flex flex-column flex-lg-row" 
                  action="{{ isset($prixcolori) ? route('admin.prixcoloris.update', $prixcolori) : route('admin.prixcoloris.store') }}" 
                  method="POST">
                @csrf
                @if(isset($prixcolori))
                    @method('PUT')
                @endif

                <div class="d-flex flex-column flex-row-fluid gap-7 gap-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Informations de tarification</h2>
                            </div>
                        </div>

                        <div class="card-body pt-0">
                            <div class="mb-10 fv-row">
                                <label class="required form-label">Coloris</label>
                                <select name="colori_id" class="form-select mb-2" data-control="select2" data-placeholder="Sélectionner un coloris" required>
                                    <option value="">Sélectionner un coloris</option>
                                    @foreach($coloris as $colori)
                                        <option value="{{ $colori->id }}" 
                                                {{ (isset($prixcolori) && $prixcolori->colori_id == $colori->id) || old('colori_id') == $colori->id ? 'selected' : '' }}>
                                            {{ $colori->titre }} - {{ $colori->matiere->titre ?? 'N/A' }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="text-muted fs-7">Sélectionnez le coloris pour cette tarification.</div>
                            </div>

                            <div class="mb-10 fv-row">
                                <label class="required form-label">Épaisseur</label>
                                <select name="epaisseur_id" class="form-select mb-2" data-control="select2" data-placeholder="Sélectionner une épaisseur" required>
                                    <option value="">Sélectionner une épaisseur</option>
                                    @foreach($epaisseurs as $epaisseur)
                                        <option value="{{ $epaisseur->id }}" 
                                                {{ (isset($prixcolori) && $prixcolori->epaisseur_id == $epaisseur->id) || old('epaisseur_id') == $epaisseur->id ? 'selected' : '' }}>
                                            {{ $epaisseur->titre }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="text-muted fs-7">Sélectionnez l'épaisseur pour cette tarification.</div>
                            </div>

                            <div class="mb-10 fv-row">
                                <label class="required form-label">Finition</label>
                                <select name="finition_id" class="form-select mb-2" data-control="select2" data-placeholder="Sélectionner une finition" required>
                                    <option value="">Sélectionner une finition</option>
                                    @foreach($finitions as $finition)
                                        <option value="{{ $finition->id }}" 
                                                {{ (isset($prixcolori) && $prixcolori->finition_id == $finition->id) || old('finition_id') == $finition->id ? 'selected' : '' }}>
                                            {{ $finition->titre }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="text-muted fs-7">Sélectionnez la finition pour cette tarification.</div>
                            </div>

                            <div class="mb-10 fv-row">
                                <label class="required form-label">Prix (€)</label>
                                <input type="number" step="0.01" min="0" name="prix" class="form-control mb-2" placeholder="0.00" 
                                       value="{{ isset($prixcolori) ? $prixcolori->prix : old('prix') }}" required />
                                <div class="text-muted fs-7">Entrez le prix en euros pour cette combinaison.</div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end">
                        <a href="{{ route('admin.prixcoloris.index') }}" class="btn btn-light me-5">Annuler</a>
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">{{ isset($prixcolori) ? 'Modifier' : 'Créer' }}</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
