
@extends('layouts.app')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">
                        Gestion des tarifications
                    </h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="{{ route('admin.prixcoloris.create') }}" class="btn btn-flex btn-primary h-40px fs-7 fw-bold">Ajout tarification</a>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
                <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-shield-tick fs-2hx text-success me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-success">Succès</h4>
                        <span>{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-information-5 fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreur</h4>
                        <span>{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-information-5 fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreur</h4>
                        <span>{{ $errors->first() }}</span>
                    </div>
                </div>
            @endif

            <div class="card card-flush">
                <div class="card-body pt-0">
                    <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_ecommerce_category_table">
                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">
                                <th width="25%" class="min-w-200px">Coloris</th>
                                <th width="20%" class="min-w-150px">Épaisseur</th>
                                <th width="20%" class="min-w-150px">Finition</th>
                                <th width="15%" class="min-w-100px">Prix (€)</th>
                                <th width="20%" class="text-end min-w-70px">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="fw-semibold text-gray-600">
                            @foreach($prixcoloris as $prix)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        @if($prix->colori->photo)
                                            <img src="{{ asset('storage/' . $prix->colori->photo) }}" alt="Photo" class="w-40px h-40px rounded me-3">
                                        @endif
                                        <div>
                                            <span class="fw-bold">{{ $prix->colori->titre }}</span>
                                            <div class="text-muted fs-7">{{ $prix->colori->matiere->titre ?? 'N/A' }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $prix->epaisseur->titre }}</td>
                                <td>{{ $prix->finition->titre }}</td>
                                <td>
                                    <span class="fw-bold text-primary">{{ number_format($prix->prix, 2, ',', ' ') }} €</span>
                                </td>
                                <td>
                                    <div class="d-flex my-3 ms-9">
                                        <div class="ms-auto">
                                            <a href="{{ route('admin.prixcoloris.edit', $prix) }}" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3">
                                                <span data-bs-toggle="tooltip" data-bs-trigger="hover" title="Modifier">
                                                    <i class="ki-outline text-warning ki-pencil fs-3"></i>
                                                </span>
                                            </a>

                                            <form action="{{ route('admin.prixcoloris.destroy', $prix) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-icon btn-active-light-primary w-30px h-30px" data-bs-toggle="tooltip" title="Suppression" onclick="return confirm('Voulez-vous continuer la suppression ?')">
                                                    <i class="ki-outline text-danger ki-trash fs-3"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $prixcoloris->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
