
@extends('layouts.app')

@section('title', isset($role) ? 'Modifier Rôle' : 'Nouveau Rôle')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                <h1 class="page-heading d-flex text-gray-900 fw-bold fs-3 flex-column justify-content-center my-0">
                    {{ isset($role) ? 'Modifier Rôle' : 'Nouveau Rôle' }}
                </h1>
            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">
                <a href="{{ route('admin.roles.index') }}" class="btn btn-flex btn-secondary h-40px fs-7 fw-bold">Retour à la liste</a>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        <h3>{{ isset($role) ? 'Modifier le rôle' : 'Créer un nouveau rôle' }}</h3>
                    </div>
                </div>

                <form action="{{ isset($role) ? route('admin.roles.update', $role) : route('admin.roles.store') }}" method="POST">
                    @csrf
                    @if(isset($role))
                        @method('PUT')
                    @endif

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Nom d'affichage</label>
                                    <input type="text" name="display_name" class="form-control @error('display_name') is-invalid @enderror" 
                                           value="{{ old('display_name', $role->display_name ?? '') }}" required>
                                    @error('display_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Nom technique</label>
                                    <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" 
                                           value="{{ old('name', $role->name ?? '') }}" required>
                                    <div class="form-text">Nom unique sans espaces (ex: admin, manager, user)</div>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-10 fv-row">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control @error('description') is-invalid @enderror" rows="3">{{ old('description', $role->description ?? '') }}</textarea>
                                    @error('description')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Ordre</label>
                                    <input type="number" name="ordre" class="form-control @error('ordre') is-invalid @enderror" 
                                           value="{{ old('ordre', $role->ordre ?? 0) }}" min="0" required>
                                    @error('ordre')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-10 fv-row">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" 
                                               {{ old('is_active', $role->is_active ?? true) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">
                                            Actif
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="separator border-gray-200 mb-10"></div>

                        <div class="mb-10">
                            <h4 class="mb-5">Permissions</h4>
                            @foreach($permissionsByCategory as $category => $permissions)
                                <div class="card card-flush mb-5">
                                    <div class="card-header">
                                        <div class="card-title">
                                            <h5 class="m-0">{{ ucfirst($category) }}</h5>
                                        </div>
                                        <div class="card-toolbar">
                                            <button type="button" class="btn btn-sm btn-light-primary" onclick="toggleCategoryPermissions('{{ $category }}')">
                                                Tout sélectionner
                                            </button>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            @foreach($permissions as $permission)
                                                <div class="col-md-4 mb-3">
                                                    <div class="form-check">
                                                        <input class="form-check-input permission-checkbox category-{{ $category }}" 
                                                               type="checkbox" name="permissions[]" value="{{ $permission->id }}" 
                                                               id="permission_{{ $permission->id }}"
                                                               {{ isset($rolePermissions) && in_array($permission->id, $rolePermissions) ? 'checked' : '' }}>
                                                        <label class="form-check-label" for="permission_{{ $permission->id }}">
                                                            <div>
                                                                <strong>{{ $permission->display_name }}</strong>
                                                                @if($permission->description)
                                                                    <div class="text-muted fs-7">{{ $permission->description }}</div>
                                                                @endif
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="card-footer d-flex justify-content-end">
                        <a href="{{ route('admin.roles.index') }}" class="btn btn-light me-3">Annuler</a>
                        <button type="submit" class="btn btn-primary">
                            {{ isset($role) ? 'Modifier' : 'Créer' }} le rôle
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function toggleCategoryPermissions(category) {
    const checkboxes = document.querySelectorAll('.category-' + category);
    const allChecked = Array.from(checkboxes).every(cb => cb.checked);
    
    checkboxes.forEach(checkbox => {
        checkbox.checked = !allChecked;
    });
}
</script>
@endsection
