
@extends('layouts.app')

@section('title', 'Gestion des Rôles')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                <h1 class="page-heading d-flex text-gray-900 fw-bold fs-3 flex-column justify-content-center my-0">Gestion des Rôles</h1>
            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">
                <a href="{{ route('admin.roles.create') }}" class="btn btn-sm fw-bold btn-primary">
                    <i class="ki-outline ki-plus fs-2"></i>Nouveau Rôle
                </a>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">

            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <div class="card">
                <div class="card-header border-0 pt-6">
                    <div class="card-title">
                        <div class="d-flex align-items-center position-relative my-1">
                            <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i>
                            <input type="text" data-kt-roles-table-filter="search" class="form-control form-control-solid w-250px ps-13" placeholder="Rechercher un rôle" />
                        </div>
                    </div>
                </div>

                <div class="card-body py-4">
                    <div class="table-responsive">
                        <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_roles">
                            <thead>
                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                    <th class="min-w-125px">Rôle</th>
                                    <th class="min-w-125px">Nom technique</th>
                                    <th class="min-w-125px">Permissions</th>
                                    <th class="min-w-100px">Utilisateurs</th>
                                    <th class="min-w-100px">Statut</th>
                                    <th class="min-w-100px">Ordre</th>
                                    <th class="text-end min-w-100px">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-semibold">
                                @foreach($roles as $role)
                                <tr>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="text-gray-800 fw-bold">{{ $role->display_name }}</span>
                                            @if($role->description)
                                                <span class="text-muted fs-7">{{ Str::limit($role->description, 50) }}</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-light-primary">{{ $role->name }}</span>
                                    </td>
                                    <td>
                                        <span class="badge badge-light-info">{{ $role->permissions->count() }} permissions</span>
                                    </td>
                                    <td>
                                        <span class="badge badge-light-warning">{{ $role->users->count() }} utilisateurs</span>
                                    </td>
                                    <td>
                                        @if($role->is_active)
                                            <span class="badge badge-light-success">Actif</span>
                                        @else
                                            <span class="badge badge-light-danger">Inactif</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="me-2">{{ $role->ordre }}</span>
                                            <div class="btn-group" role="group">
                                                <form action="{{ route('admin.roles.moveUp', $role) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-light-primary" title="Monter">
                                                        <i class="ki-outline ki-up fs-7"></i>
                                                    </button>
                                                </form>
                                                <form action="{{ route('admin.roles.moveDown', $role) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-light-primary" title="Descendre">
                                                        <i class="ki-outline ki-down fs-7"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.roles.show', $role) }}" class="btn btn-sm btn-light-info" title="Voir">
                                                <i class="ki-outline ki-eye fs-7"></i>
                                            </a>
                                            <a href="{{ route('admin.roles.edit', $role) }}" class="btn btn-sm btn-light-primary" title="Modifier">
                                                <i class="ki-outline ki-pencil fs-7"></i>
                                            </a>
                                            <a href="{{ route('admin.roles.toggle-status', $role) }}" class="btn btn-sm btn-light-warning" title="Activer/Désactiver">
                                                <i class="ki-outline ki-switch fs-7"></i>
                                            </a>
                                            @if($role->users->count() == 0)
                                                <form action="{{ route('admin.roles.destroy', $role) }}" method="POST" class="d-inline" onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer ce rôle ?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-light-danger" title="Supprimer">
                                                        <i class="ki-outline ki-trash fs-7"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    {{ $roles->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
