
@extends('layouts.app')

@section('content')

<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">

        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">

            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">

                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">

                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">{{ isset($user) ? 'Modifier' : 'Créer' }} un Utilisateur</h1>

                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">

                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('admin.users.index') }}" class="text-muted text-hover-primary">Utilisateurs</a>
                        </li>
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-500 w-5px h-2px"></span>
                        </li>
                        <li class="breadcrumb-item text-muted">{{ isset($user) ? 'Modifier' : 'Créer' }}</li>

                    </ul>

                </div>

                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="{{ route('admin.users.index') }}" class="btn btn-flex btn-secondary h-40px fs-7 fw-bold">Retour à la liste</a>
                </div>

            </div>

        </div>

    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">

        <div id="kt_app_content_container" class="app-container container-fluid">

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ isset($user) ? route('admin.users.update', $user) : route('admin.users.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                @if(isset($user))
                    @method('PUT')
                @endif

                <div class="d-flex flex-column flex-xl-row">

                    <div class="flex-column flex-lg-row-auto w-100 w-xl-350px mb-10">

                        <div class="card mb-5 mb-xl-8">

                            <div class="card-body pt-15">

                                <div class="d-flex flex-center flex-column mb-5">

                                    <div class="card-body text-center pt-0">

                                        <div class="image-input image-input-empty image-input-outline image-input-placeholder mb-3" data-kt-image-input="true">

                                            <div class="image-input-wrapper w-150px h-150px" style="background-image: url({{ isset($user) && $user->image ? asset('storage/' . $user->image) : '/assets/media/avatars/300-1.jpg' }})"></div>

                                            <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Changer l'avatar">

                                                <i class="ki-outline ki-pencil fs-7"></i>

                                                <input type="file" name="image" accept=".png, .jpg, .jpeg" />
                                                <input type="hidden" name="image_remove" />

                                            </label>

                                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Annuler avatar">
                                                <i class="ki-outline ki-cross fs-2"></i>
                                            </span>

                                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Supprimer avatar">
                                                <i class="ki-outline ki-cross fs-2"></i>
                                            </span>

                                        </div>

                                        <div class="text-muted fs-7">Seulement les extensions *.png, *.jpg et *.jpeg image sont acceptées</div>

                                    </div>

                                    <a href="#" class="fs-3 text-gray-800 text-hover-primary fw-bold mb-1">{{ isset($user) ? $user->name : 'Nouvel Utilisateur' }}</a>

                                    <div class="fs-5 fw-semibold text-muted mb-6">{{ isset($user) ? 'Utilisateur' : 'Nouvel utilisateur' }}</div>

                                </div>

                                <div class="d-flex flex-stack fs-4 py-3">
                                    <div class="">
                                        <div class="card-title">
                                            <h3 class="fw-bold m-0">Détails de l'utilisateur</h3>
                                        </div>
                                    </div>
                                    <span data-bs-toggle="tooltip" data-bs-trigger="hover" title="Modifier les détails de l'utilisateur">

                                    </span>
                                </div>

                                <div class="separator separator-dashed my-3"></div>

                                <div id="kt_customer_view_details">
                                    <div class="py-5 fs-6">

                                        <div class="fw-bold mt-5">Nom</div>
                                        <div class="text-gray-600">{{ isset($user) ? $user->name : 'À définir' }}</div>

                                        <div class="fw-bold mt-5">Email</div>
                                        <div class="text-gray-600">
                                            <a href="#" class="text-gray-600 text-hover-primary">{{ isset($user) ? $user->email : 'À définir' }}</a>
                                        </div>

                                        <div class="fw-bold mt-5">Statut</div>
                                        <div class="text-gray-600">
                                            @if(isset($user))
                                                @if($user->is_active)
                                                    <span class="badge badge-success">Actif</span>
                                                @else
                                                    <span class="badge badge-danger">Inactif</span>
                                                @endif
                                            @else
                                                <span class="badge badge-success">Actif par défaut</span>
                                            @endif
                                        </div>

                                        <div class="fw-bold mt-5">Date de création</div>
                                        <div class="text-gray-600">{{ isset($user) ? $user->created_at->format('d/m/Y H:i') : 'Nouveau' }}</div>

                                    </div>
                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="flex-lg-row-fluid ms-lg-15">

                        <div class="card card-flush py-4">

                            <div class="card-header">
                                <div class="card-title">
                                    <h2>{{ isset($user) ? 'Modifier l\'utilisateur' : 'Créer un utilisateur' }}</h2>
                                </div>
                            </div>

                            <div class="card-body pt-0">

                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Nom</label>
                                    <input type="text" name="name" class="form-control mb-2 @error('name') is-invalid @enderror" placeholder="Nom complet" value="{{ old('name', $user->name ?? '') }}" required />
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Email</label>
                                    <input type="email" name="email" class="form-control mb-2 @error('email') is-invalid @enderror" placeholder="Adresse email" value="{{ old('email', $user->email ?? '') }}" required />
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                @if(isset($user) && $user->id != auth()->id())
                                <div class="mb-10 fv-row">
                                    <label class="form-label">Mot de passe</label>
                                    <input type="password" name="password" class="form-control mb-2 @error('password') is-invalid @enderror" placeholder="Mot de passe" {{ !isset($user) ? 'required' : '' }} />
                                    @if(isset($user))
                                        <div class="form-text">Laissez vide pour conserver le mot de passe actuel</div>
                                    @endif
                                    @error('password')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-10 fv-row">
                                    <label class="form-label">Confirmer le mot de passe</label>
                                    <input type="password" name="password_confirmation" class="form-control mb-2" placeholder="Confirmer le mot de passe" {{ !isset($user) ? 'required' : '' }} />
                                </div>
                                @endif

                                <div class="mb-10 fv-row">
                                    <label class="form-label">Téléphone</label>
                                    <input type="tel" name="telephone" class="form-control mb-2 @error('telephone') is-invalid @enderror" placeholder="Numéro de téléphone" value="{{ old('telephone', $user->telephone ?? '') }}" />
                                    @error('telephone')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-10 fv-row">
                                    <label class="form-label">Adresse</label>
                                    <input type="text" name="adresse" class="form-control mb-2 @error('adresse') is-invalid @enderror" placeholder="Adresse complète" value="{{ old('adresse', $user->adresse ?? '') }}" />
                                    @error('adresse')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-10 fv-row">
                                            <label class="form-label">Ville</label>
                                            <input type="text" name="ville" class="form-control mb-2 @error('ville') is-invalid @enderror" placeholder="Ville" value="{{ old('ville', $user->ville ?? '') }}" />
                                            @error('ville')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-10 fv-row">
                                            <label class="form-label">Code postal</label>
                                            <input type="text" name="code_postal" class="form-control mb-2 @error('code_postal') is-invalid @enderror" placeholder="Code postal" value="{{ old('code_postal', $user->code_postal ?? '') }}" />
                                            @error('code_postal')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-10 fv-row">
                                    <label class="form-label">Pays</label>
                                    <input type="text" name="pays" class="form-control mb-2 @error('pays') is-invalid @enderror" placeholder="Pays" value="{{ old('pays', $user->pays ?? 'France') }}" />
                                    @error('pays')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Rôle</label>
                                    <select name="role_id" class="form-select @error('role_id') is-invalid @enderror" required>
                                        <option value="">Sélectionner un rôle</option>
                                        @foreach($roles as $role)
                                            <option value="{{ $role->id }}" {{ old('role_id', $user->role_id ?? '') == $role->id ? 'selected' : '' }}>
                                                {{ $role->display_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('role_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-10 fv-row">
                                    <label class="form-label">Date de naissance</label>
                                    <input type="date" name="date_naissance" class="form-control mb-2 @error('date_naissance') is-invalid @enderror" value="{{ old('date_naissance', isset($user) && $user->date_naissance ? $user->date_naissance->format('Y-m-d') : '') }}" />
                                    @error('date_naissance')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-10 fv-row">
                                    <label class="form-label">Statut</label>
                                    <div class="form-check form-switch form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" 
                                               value="1" {{ old('is_active', isset($user) ? $user->is_active : true) ? 'checked' : '' }} />
                                        <label class="form-check-label" for="is_active">
                                            Utilisateur actif
                                        </label>
                                    </div>
                                </div>

                            </div>

                            <div class="d-flex justify-content-end mt-10">
                                <a href="{{ route('admin.users.index') }}" class="btn btn-light btn-active-light-primary me-2">Annuler</a>
                                <button type="submit" class="btn btn-primary">
                                    {{ isset($user) ? 'Modifier' : 'Créer' }} l'utilisateur
                                </button>
                            </div>

                        </div>

                    </div>

                </div>

            </form>

        </div>
    </div>
</div>

@endsection
