
@extends('layouts.front')

@section('title', $matiere->meta_title ?: $matiere->titre)
@section('meta_description', $matiere->meta_description ?: $matiere->description)

@section('content')
<div class="container">
    <div class="row">
        <div class="col-lg-12">
            <div class="page-header">
                <h1 class="page-title">{{ $matiere->titre }}</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}">Accueil</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ $matiere->titre }}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-6">
            @if($matiere->photo)
                <div class="matiere-image">
                    <img src="{{ asset('storage/' . $matiere->photo) }}" alt="{{ $matiere->titre }}" class="img-fluid">
                </div>
            @endif
        </div>
        
        <div class="col-lg-6">
            <div class="matiere-content">
                <h2>{{ $matiere->titre }}</h2>
                
                @if($matiere->categoriematiere)
                    <p><strong>Catégorie :</strong> {{ $matiere->categoriematiere->titre }}</p>
                @endif
                
                @if($matiere->description)
                    <div class="matiere-description">
                        <h3>Description</h3>
                        <p>{{ $matiere->description }}</p>
                    </div>
                @endif

                @if($matiere->logo)
                    <div class="matiere-logo mt-4">
                        <img src="{{ asset('storage/' . $matiere->logo) }}" alt="Logo {{ $matiere->titre }}" class="img-fluid" style="max-height: 100px;">
                    </div>
                @endif

                <div class="mt-4">
                    <a href="{{ url('/contact') }}" class="ecogranit-btn-devis">
                        <span>Demander un devis</span>
                        <i class="icon-right-arrow"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if($matiere->coloris->count() > 0)
    <div class="row mt-5">
        <div class="col-lg-12">
            <h3>Coloris disponibles</h3>
            <div class="row">
                @foreach($matiere->coloris as $colori)
                    <div class="col-md-4 mb-3">
                        <div class="colori-card">
                            @if($colori->photo)
                                <img src="{{ asset('storage/' . $colori->photo) }}" alt="{{ $colori->titre }}" class="img-fluid">
                            @endif
                            <h5>{{ $colori->titre }}</h5>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif
</div>
@endsection
