
@extends('layouts.front')

@section('content')

<section class="page-header">
    <div class="page-header__bg" style="background-image: url('assets/img/bg_head.jpg');"></div>
    <div class="container">
        <h2 class="page-header__title">{{ $categoriematiere->titre }}</h2>
        <ul class="floens-breadcrumb list-unstyled">
            <li><i class="icon-home"></i> <a href="{{ url('/') }}">Accueil</a></li>
            <li><span>Nos matériaux</span></li>
            <li><span>{{ $categoriematiere->titre }}</span></li>
        </ul>
    </div>
</section>

<section class="product-page section-space-bottom">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="product__page-title-box">
                    <p class="product__page-text text-center">{{ $categoriematiere->description }}</p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="row gutter-y-30">
                    @php
                    $matieres = \App\Models\Matiere::where('categoriematiere_id', $categoriematiere->id)
                                                   ->where('pub', 1)
                                                   ->orderBy('ordre', 'desc')
                                                   ->get();
                    @endphp
                    
                    @forelse($matieres as $matiere)
                    <div class="col-xl-4 col-md-6">
                        <div class="service-card-two">
                            <div class="service-card-two__image">
                                @if($matiere->photo)
                                    <img src="{{ asset('storage/' . $matiere->photo) }}" alt="{{ $matiere->titre }}">
                                @else
                                    <img src="assets/img/list.jpg" alt="{{ $matiere->titre }}">
                                @endif
                            </div>
                            <div class="service-card-two__content">
                                <div class="text-left">
                                    <div class="d-flex justify-content-between liste_prod mb-3">
                                        <h4 class="product__item__title">
                                            <a href="{{ url('/' . $categoriematiere->slug . '/' . $matiere->slug) }}">{{ $matiere->titre }}</a>
                                        </h4>
                                    </div>
                                    @if($matiere->description)
                                        <p class="mb-3">{{ Str::limit($matiere->description, 100) }}</p>
                                    @endif
                                    <a href="{{ url('/contact') }}" class="ecogranit-btn-devis btn-devis-small">
                                        <span>Devis en ligne</span>
                                        <i class="icon-right-arrow"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="col-12">
                        <div class="text-center">
                            <p>Aucun matériau disponible dans cette catégorie pour le moment.</p>
                        </div>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</section>

<section class="faq-one section-space">
    <div class="container">
        <div class="row gutter-y-60">
            <div class="col-lg-6 wow fadeInLeft" data-wow-duration="1500ms">
                <div class="faq-one__image">
                    <div class="faq-one__image__inner">
                        <img src="/frontassets/img/faq.jpg" alt="faq" class="faq-one__image__one">
                    </div>
                </div>
            </div>
            <div class="col-lg-6 wow fadeInRight" data-wow-duration="1500ms" data-wow-delay="200ms">
                <div class="faq-one__content">
                    <div class="sec-title sec-title--border">
                        <h6 class="sec-title__tagline">NOTRE FAQ</h6>
                        <h3 class="sec-title__title">Guide des questions les plus Courantes</h3>
                    </div>
                    <p class="faq-one__text">Mollis massa turpis, eu sodales sem maximus ut. Nullam condimentum eget arcu nec dapibus. Nullam tincidunt ex ut tempus malesuada.</p>
                    <div class="faq-accordion floens-accordion" data-grp-name="floens-accordion">
                        <div class="accordion active">
                            <div class="accordion-title">
                                <h4>
                                    Quels sont les avantages d'Eco-granit.com ?
                                    <span class="accordion-title__icon"></span>
                                </h4>
                            </div>
                            <div class="accordion-content">
                                <div class="inner">
                                    <p>Bring to the table win-win survival strategies to ensure proactive domination. At the
                                        end of the day, going forward, a new normal that has evolved from generation X is on
                                        the</p>
                                </div>
                            </div>
                        </div>
                        <div class="accordion">
                            <div class="accordion-title">
                                <h4>
                                    Comment obtenir un devis ?
                                    <span class="accordion-title__icon"></span>
                                </h4>
                            </div>
                            <div class="accordion-content">
                                <div class="inner">
                                    <p>Bring to the table win-win survival strategies to ensure proactive domination. At the
                                        end of the day, going forward, a new normal that has evolved from generation X is on
                                        the</p>
                                </div>
                            </div>
                        </div>
                        <div class="accordion">
                            <div class="accordion-title">
                                <h4>
                                    Comment effectuer le règlement ?
                                    <span class="accordion-title__icon"></span>
                                </h4>
                            </div>
                            <div class="accordion-content">
                                <div class="inner">
                                    <p>Bring to the table win-win survival strategies to ensure proactive domination. At the
                                        end of the day, going forward, a new normal that has evolved from generation X is on
                                        the</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="testimonials-one section-space">
    <div class="container">
        <div class="row">
            <div class="testimonials-one__image-col col-lg-6 wow fadeInLeft" data-wow-duration="1500ms">
                <div class="testimonials-one__image">
                    <img src="/frontassets/img/tem.jpg" alt="testimonials">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="sec-title @@extraClassName">
                    <h6 class="sec-title__tagline">Témoignages</h6>
                    <h3 class="sec-title__title">Avis de nos clients sur nos services</h3>
                </div>
            </div>
            <div class="testimonials-one__testimonials-col col-xl-9">
                <div class="testimonials-one__carousel floens-owl__carousel floens-owl__carousel--basic-nav owl-carousel owl-theme"
                    data-owl-options='{
                        "items": 1,
                        "margin": 0,
                        "loop": true,
                        "smartSpeed": 700,
                        "nav": false,
                     "navText": ["<span class=\"icon-slide-left-arrow\"></span>","<span class=\"icon-slide-right-arrow\"></span>"],
                        "dots": true,
                        "autoplay": 600,
                        "responsive":{
                            "0":{
                                "items": 1,
                                "margin": 15
                            },
                            "576":{
                                "items": 1,
                                "margin": 30
                            },
                            "768":{
                                "items": 1,
                                "margin": 30
                            },
                            "992":{
                                "items": 1,
                                "margin": 30
                            },
                            "1200":{
                                "items": 1,
                                "margin": 30
                            }
                        }
                    }'>
                     @php
                    $temoinages = \App\Models\Temoinage::where('pub', 1)->orderBy('ordre', 'desc')->get();
                @endphp
                @forelse($temoinages as $temoinage)
                    <div class="item">
                        <div class="testimonials-card testimonials-card--two">
                            <div class="testimonials-card__bg"
                                style="background-image: url(/frontassets/img/testimonials/testimonials-card-bg.png);">
                            </div>
                            <div class="testimonials-card__top">
                                <svg class="testimonials-card__quotes__icon" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 87 64" fill="none">
                                    <path d="M0 40.1428H17.5714L5.85705 63.5713H23.4285L35.1428 40.1428V5H0V40.1428Z"
                                        fill="white" />
                                    <path d="M46.8572 5V40.1428H64.4286L52.7142 63.5713H70.2856L82 40.1428V5H46.8572Z"
                                        fill="white" />
                                    <path
                                        d="M22.5714 34.6428H5.5V0.5H39.6428V35.0248L28.1194 58.0713H11.6661L23.0186 35.3664L23.3804 34.6428H22.5714Z"
                                        stroke="#C7844F" />
                                    <path
                                        d="M69.4286 34.6428H52.3572V0.5H86.5V35.0248L74.9766 58.0713H58.5232L69.8758 35.3664L70.2376 34.6428H69.4286Z"
                                        stroke="#C7844F" />
                                </svg>
                                <div class="ecogranit-ratings @@extraClassName">
    <span class="icon-star"></span>
    <span class="icon-star"></span>
    <span class="icon-star"></span>
    <span class="icon-star"></span>
    <span class="icon-star"></span>
</div>
                            </div>
                            <div class="testimonials-card__content">
                                <div class="testimonials-card__content__inner">
                                    <p class="testimonials-card__text">{{ $temoinage->description }}</p>
                                </div>
                                <div class="testimonials-card__person">
                                    <div class="testimonials-card__person__inner">
                                        <img src="{{ asset('storage/' . $temoinage->photo) }}" width="150" alt="{{ $temoinage->nom }}" class="testimonials-card__image">
                                        <div class="testimonials-card__person__info">
                                            <h3 class="testimonials-card__person__name">{{ $temoinage->nom }}</h3>
                                            <span class="testimonials-card__person__designation">{{ $temoinage->titre }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                     @empty
                    <div class="item">
                        <div class="testimonials-card testimonials-card--two">
                            <div class="testimonials-card__bg"
                                style="background-image: url(/frontassets/img/testimonials/testimonials-card-bg.png);">
                            </div>
                            <div class="testimonials-card__top">
                                <svg class="testimonials-card__quotes__icon" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 87 64" fill="none">
                                    <path d="M0 40.1428H17.5714L5.85705 63.5713H23.4285L35.1428 40.1428V5H0V40.1428Z"
                                        fill="white" />
                                    <path d="M46.8572 5V40.1428H64.4286L52.7142 63.5713H70.2856L82 40.1428V5H46.8572Z"
                                        fill="white" />
                                    <path
                                        d="M22.5714 34.6428H5.5V0.5H39.6428V35.0248L28.1194 58.0713H11.6661L23.0186 35.3664L23.3804 34.6428H22.5714Z"
                                        stroke="#C7844F" />
                                    <path
                                        d="M69.4286 34.6428H52.3572V0.5H86.5V35.0248L74.9766 58.0713H58.5232L69.8758 35.3664L70.2376 34.6428H69.4286Z"
                                        stroke="#C7844F" />
                                </svg>
                                <div class="ecogranit-ratings @@extraClassName">
    <span class="icon-star"></span>
    <span class="icon-star"></span>
    <span class="icon-star"></span>
    <span class="icon-star"></span>
    <span class="icon-star"></span>
</div>
                            </div>
                            <div class="testimonials-card__content">
                                <div class="testimonials-card__content__inner">
                                    <p class="testimonials-card__text">Aucun témoignage disponible pour le moment.</p>
                                </div>
                                <div class="testimonials-card__person">
                                    <div class="testimonials-card__person__inner">
                                        <img src="/frontassets/img/testimonials/testimonials-1-1.jpg" alt="Aucun témoignage"
                                            class="testimonials-card__image">
                                        <div class="testimonials-card__person__info">
                                            <h3 class="testimonials-card__person__name">Aucun témoignage</h3>
                                            <span class="testimonials-card__person__designation">Aucun témoignage</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</section>

<section class="projects-two projects-two--home section-space-bottom">
    <div class="container">
        <div class="sec-title sec-title--center">
    <h6 class="sec-title__tagline">Nos partenaires</h6>
    <h3 class="sec-title__title">Nos partenaires <br> depuis 20 ans</h3>
</div>
    </div>
    <div class="container-fluid">
    <div class="projects-two__carousel floens-owl__carousel floens-owl__carousel--basic-nav owl-theme owl-carousel"
        data-owl-options='{
        "items": 3,
        "margin": 30,
        "smartSpeed": 700,
        "loop": true,
        "autoWidth": true,
        "autoplay": true,
        "nav": true,
        "dots": false,
        "navText": ["<span class=\"icon-slide-left-arrow\"></span>","<span class=\"icon-slide-right-arrow\"></span>"]
        }'>
        @php
        $partenaires = \App\Models\Partenaire::where('pub', 1)->orderBy('ordre', 'desc')->get();
        @endphp
        @forelse($partenaires as $partenaire)
        <div class="item">
            <img src="{{ asset('storage/' . $partenaire->photo) }}" alt="{{ $partenaire->titre }}">
        </div>
        @empty
        <div class="item">
        <img src="/frontassets/img/part-1.jpg" alt="Modern Tiles">
            </div>
        <div class="item">
             <img src="/frontassets/img/part-2.jpg" alt="Modern Tiles">
        </div>
        <div class="item">
        <img src="/frontassets/img/part-3.jpg" alt="Modern Tiles">
        </div>
         <div class="item">
        <img src="/frontassets/img/part-4.jpg" alt="Modern Tiles">
        </div>
        @endforelse
    </div>
</div>
</section>

@endsection
