<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PasswordController;

use App\Http\Controllers\EpaisseurController;
use App\Http\Controllers\BordureController;
use App\Http\Controllers\FinitionController;
use App\Http\Controllers\CategorimatiereController;
use App\Http\Controllers\MatiereController;
use App\Http\Controllers\ColoriController;
use App\Http\Controllers\PhotocoloriController;
use App\Http\Controllers\PrixcoloriController;
use App\Http\Controllers\OptionsdecoupeController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\CategorieaccessoireController;
use App\Http\Controllers\AccessoiremarqueController;
use App\Http\Controllers\AccessoireController;
use App\Http\Controllers\CategorieblogController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\SlideController;
use App\Http\Controllers\DeviController;
use App\Http\Controllers\TemoinageController;
use App\Http\Controllers\NosprojetController;
use App\Http\Controllers\PartenaireController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Auth\LoginController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    $slides = \App\Models\Slide::where('pub', 1)->orderBy('ordre', 'desc')->get();
    $matieres = \App\Models\Matiere::with('categoriematiere')->where('pub', 1)->orderBy('ordre', 'desc')->get();
    $blogs = \App\Models\Blog::with('categorieblog')
        ->where('pub', 1)
        ->orderBy('created_at', 'desc')
        ->take(3)
        ->get();
    $nosprojets = \App\Models\Nosprojet::where('pub', 1)->orderBy('ordre', 'desc')->get();
    return view('welcome', compact('slides', 'matieres', 'blogs', 'nosprojets'));
});

Route::get('/materiaux/{slug}', function ($slug) {
    $categoriematiere = \App\Models\Categoriematiere::where('slug', $slug)->where('pub', 1)->firstOrFail();
    return view('materiaux', compact('categoriematiere'));
})->name('materiaux.categorie');

// Routes d'authentification
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Routes Admin (protégées par authentification)
Route::prefix('admin')->name('admin.')->middleware('auth')->group(function () {
    // Routes pour le changement de mot de passe
    Route::get('/password/change', [PasswordController::class, 'showChangeForm'])->name('password.change');
    Route::put('/password/update', [PasswordController::class, 'updatePassword'])->name('password.update');

    // Routes de ressources
    Route::resource('epaisseurs', EpaisseurController::class);
    Route::resource('bordures', BordureController::class);
    Route::resource('finitions', FinitionController::class);
    Route::resource('categoriematieres', CategorimatiereController::class);
    Route::resource('matieres', MatiereController::class);
    Route::resource('coloris', ColoriController::class);
    Route::resource('photocoloris', PhotocoloriController::class);
    Route::resource('prixcoloris', PrixcoloriController::class);
    Route::resource('optionsdecoupes', OptionsdecoupeController::class);
    Route::resource('services', ServiceController::class);
    Route::resource('categorieaccessoires', CategorieaccessoireController::class);
    Route::resource('accessoiremarques', AccessoiremarqueController::class);
    Route::resource('accessoires', AccessoireController::class);
    Route::resource('categorieblogs', CategorieblogController::class);
    Route::resource('blogs', BlogController::class);
    

    // Routes spéciales pour l'ordre et la publication - Bordures
    Route::post('/bordures/{bordure}/move-up', [BordureController::class, 'moveUp'])->name('bordures.moveUp');
    Route::post('/bordures/{bordure}/move-down', [BordureController::class, 'moveDown'])->name('bordures.moveDown');
    Route::get('/bordures/{id}/toggle-publication', [BordureController::class, 'togglePublication'])->name('bordures.toggle-publication');

    // Routes spéciales pour l'ordre et la publication - Catégories matières
    Route::post('/categoriematieres/{categoriematiere}/move-up', [CategorimatiereController::class, 'moveUp'])->name('categoriematieres.moveUp');
    Route::post('/categoriematieres/{categoriematiere}/move-down', [CategorimatiereController::class, 'moveDown'])->name('categoriematieres.moveDown');
    Route::get('/categoriematieres/{id}/toggle-publication', [CategorimatiereController::class, 'togglePublication'])->name('categoriematieres.toggle-publication');

    // Routes spéciales pour l'ordre et la publication - Matières
    Route::post('/matieres/{matiere}/move-up', [MatiereController::class, 'moveUp'])->name('matieres.moveUp');
    Route::post('/matieres/{matiere}/move-down', [MatiereController::class, 'moveDown'])->name('matieres.moveDown');
    Route::get('/matieres/{id}/toggle-publication', [MatiereController::class, 'togglePublication'])->name('matieres.toggle-publication');

    // Routes spéciales pour l'ordre et la publication - Coloris
    Route::post('/coloris/{colori}/move-up', [ColoriController::class, 'moveUp'])->name('coloris.moveUp');
    Route::post('/coloris/{colori}/move-down', [ColoriController::class, 'moveDown'])->name('coloris.moveDown');
    Route::get('/coloris/{id}/toggle-publication', [ColoriController::class, 'togglePublication'])->name('coloris.toggle-publication');

    // Routes spéciales pour l'ordre et la publication - Photo coloris
    Route::post('/photocoloris/{photocolori}/move-up', [PhotocoloriController::class, 'moveUp'])->name('photocoloris.moveUp');
    Route::post('/photocoloris/{photocolori}/move-down', [PhotocoloriController::class, 'moveDown'])->name('photocoloris.moveDown');
    Route::get('/photocoloris/{id}/toggle-publication', [PhotocoloriController::class, 'togglePublication'])->name('photocoloris.toggle-publication');
    Route::delete('/photocoloris/{photocolori}', [PhotocoloriController::class, 'destroy'])->name('admin.photocoloris.destroy');

    // Routes spéciales pour l'ordre et la publication - Prix coloris
    Route::post('/prixcoloris/{prixcolori}/move-up', [PrixcoloriController::class, 'moveUp'])->name('prixcoloris.moveUp');
    Route::post('/prixcoloris/{prixcolori}/move-down', [PrixcoloriController::class, 'moveDown'])->name('prixcoloris.moveDown');
    Route::get('/prixcoloris/{id}/toggle-publication', [PrixcoloriController::class, 'togglePublication'])->name('prixcoloris.toggle-publication');
    Route::delete('/prixcoloris/{prixcolori}', [PrixcoloriController::class, 'destroy'])->name('prixcoloris.destroy');

    // Routes spéciales pour l'ordre et la publication - Options découpe
    Route::post('/optionsdecoupes/{optionsdecoupe}/move-up', [OptionsdecoupeController::class, 'moveUp'])->name('optionsdecoupes.moveUp');
    Route::post('/optionsdecoupes/{optionsdecoupe}/move-down', [OptionsdecoupeController::class, 'moveDown'])->name('optionsdecoupes.moveDown');
    Route::get('/optionsdecoupes/{optionsdecoupe}/toggle-publication', [OptionsdecoupeController::class, 'togglePublication'])->name('optionsdecoupes.togglePublication');

    // Routes spéciales pour l'ordre et la publication - Services
    Route::post('/services/{service}/move-up', [ServiceController::class, 'moveUp'])->name('services.moveUp');
    Route::post('/services/{service}/move-down', [ServiceController::class, 'moveDown'])->name('services.moveDown');
    Route::get('/services/{service}/toggle-publication', [ServiceController::class, 'togglePublication'])->name('services.togglePublication');

    // Routes spéciales pour l'ordre et la publication - Catégories accessoires
    Route::post('/categorieaccessoires/{categorieaccessoire}/move-up', [CategorieaccessoireController::class, 'moveUp'])->name('categorieaccessoires.moveUp');
    Route::post('/categorieaccessoires/{categorieaccessoire}/move-down', [CategorieaccessoireController::class, 'moveDown'])->name('categorieaccessoires.moveDown');
    Route::get('/categorieaccessoires/{id}/toggle-publication', [CategorieaccessoireController::class, 'togglePublication'])->name('categorieaccessoires.toggle-publication');

    // Routes spéciales pour l'ordre et la publication - Accessoires marques
    Route::post('/accessoiremarques/{accessoiremarque}/move-up', [AccessoiremarqueController::class, 'moveUp'])->name('accessoiremarques.moveUp');
    Route::post('/accessoiremarques/{accessoiremarque}/move-down', [AccessoiremarqueController::class, 'moveDown'])->name('accessoiremarques.moveDown');
    Route::get('/accessoiremarques/{id}/toggle-publication', [AccessoiremarqueController::class, 'togglePublication'])->name('accessoiremarques.toggle-publication');

    // Routes spéciales pour l'ordre et la publication - Accessoires
    Route::post('/accessoires/{accessoire}/move-up', [AccessoireController::class, 'moveUp'])->name('accessoires.moveUp');
    Route::post('/accessoires/{accessoire}/move-down', [AccessoireController::class, 'moveDown'])->name('accessoires.moveDown');
    Route::get('/accessoires/{id}/toggle-publication', [AccessoireController::class, 'togglePublication'])->name('accessoires.toggle-publication');

    // Routes spéciales pour l'ordre et la publication - Épaisseurs
    Route::post('/epaisseurs/{epaisseur}/move-up', [EpaisseurController::class, 'moveUp'])->name('epaisseurs.moveUp');
    Route::post('/epaisseurs/{epaisseur}/move-down', [EpaisseurController::class, 'moveDown'])->name('epaisseurs.moveDown');
    Route::get('/epaisseurs/{id}/toggle-publication', [EpaisseurController::class, 'togglePublication'])->name('epaisseurs.toggle-publication');

    // Routes spéciales pour l'ordre et la publication - Finitions
    Route::post('/finitions/{finition}/move-up', [FinitionController::class, 'moveUp'])->name('finitions.moveUp');
    Route::post('/finitions/{finition}/move-down', [FinitionController::class, 'moveDown'])->name('finitions.moveDown');
    Route::get('/finitions/{id}/toggle-publication', [FinitionController::class, 'togglePublication'])->name('finitions.toggle-publication');

    // Routes spéciales pour l'ordre et la publication - Catégories blogs
    Route::post('/categorieblogs/{categorieblog}/move-up', [CategorieblogController::class, 'moveUp'])->name('categorieblogs.moveUp');
    Route::post('/categorieblogs/{categorieblog}/move-down', [CategorieblogController::class, 'moveDown'])->name('categorieblogs.moveDown');
    Route::get('/categorieblogs/{id}/toggle-publication', [CategorieblogController::class, 'togglePublication'])->name('categorieblogs.toggle-publication');

    // Routes spéciales pour l'ordre et la publication - Blogs
    Route::post('/blogs/{blog}/move-up', [BlogController::class, 'moveUp'])->name('blogs.moveUp');
    Route::post('/blogs/{blog}/move-down', [BlogController::class, 'moveDown'])->name('blogs.moveDown');
    Route::get('/blogs/{id}/toggle-publication', [BlogController::class, 'togglePublication'])->name('blogs.toggle-publication');

    // Routes pour les slides
    Route::resource('slides', SlideController::class);
    Route::post('/slides/{slide}/move-up', [SlideController::class, 'moveUp'])->name('slides.moveUp');
    Route::post('/slides/{slide}/move-down', [SlideController::class, 'moveDown'])->name('slides.moveDown');
    Route::get('/slides/{slide}/toggle-publication', [SlideController::class, 'togglePublication'])->name('slides.toggle-publication');

     // Routes pour les devis
    Route::resource('devis', DeviController::class);
    Route::post('devis/calculate-total', [DeviController::class, 'calculateTotal'])->name('devis.calculate-total');
    Route::post('devis/auto-save', [DeviController::class, 'autoSave'])->name('devis.auto-save');
    Route::get('devis/{devi}/pdf', [DeviController::class, 'generatePdf'])->name('devis.pdf');
    Route::get('devis/{devi}/preview-pdf', [DeviController::class, 'previewPdf'])->name('devis.preview-pdf');
    Route::get('/admin/devis/{devi}', [DeviController::class, 'show'])->name('admin.devis.show');
    Route::get('/admin/devis/{devi}/edit', [DeviController::class, 'edit'])->name('admin.devis.edit');
    Route::put('/admin/devis/{devi}', [DeviController::class, 'update'])->name('admin.devis.update');
    Route::delete('/admin/devis/{devi}', [DeviController::class, 'destroy'])->name('admin.devis.destroy');
    Route::get('/admin/devis/{devi}/pdf', [DeviController::class, 'generatePdf'])->name('admin.devis.pdf');
    Route::get('/admin/devis/{devi}/preview-pdf', [DeviController::class, 'previewPdf'])->name('admin.devis.preview-pdf');


    // Route pour récupérer les coloris par matière (AJAX)
    Route::get('coloris/by-matiere/{matiere}', [ColoriController::class, 'getByMatiere'])->name('admin.coloris.by-matiere');
    Route::get('coloris/{colori_id}/photo', [ColoriController::class, 'getPhoto'])->name('admin.coloris.photo');
    Route::get('finitions/by-coloris/{coloris}', [FinitionController::class, 'getFinitionsByColoris'])->name('admin.finitions.by-coloris');
    Route::get('/admin/epaisseurs/by-coloris-finition/{coloris_id}/{finition_id}', [EpaisseurController::class, 'getByColorisFinition']);
    Route::post('devis/calculate-total', [DeviController::class, 'calculateTotal'])->name('devis.calculate-total');
    Route::get('epaisseurs/by-coloris-finition/{coloris}/{finition}', [EpaisseurController::class, 'getEpaisseursByColoriFinition'])->name('admin.epaisseurs.by-coloris-finition');
    Route::get('bordures/all', [BordureController::class, 'getAllBordures'])->name('admin.bordures.all');
    Route::get('optionsdecoupes/all', [OptionsdecoupeController::class, 'getAllOptionsdecoupes'])->name('admin.optionsdecoupes.all');

    Route::post('/devis/auto-save', [DeviController::class, 'autoSave'])->name('devis.auto-save');
    Route::resource('categorieblogs', CategorieblogController::class);

    // Routes pour les témoignages
    Route::resource('temoinages', TemoinageController::class);
    Route::post('/temoinages/{temoinage}/move-up', [TemoinageController::class, 'moveUp'])->name('temoinages.moveUp');
    Route::post('/temoinages/{temoinage}/move-down', [TemoinageController::class, 'moveDown'])->name('temoinages.moveDown');
    Route::get('/temoinages/{temoinage}/toggle-publication', [TemoinageController::class, 'togglePublication'])->name('temoinages.toggle-publication');

    // Routes pour les nosprojets
    Route::resource('nosprojets', NosprojetController::class);
    Route::post('/nosprojets/{nosprojet}/move-up', [NosprojetController::class, 'moveUp'])->name('nosprojets.moveUp');
    Route::post('/nosprojets/{nosprojet}/move-down', [NosprojetController::class, 'moveDown'])->name('nosprojets.moveDown');
    Route::get('/nosprojets/{nosprojet}/toggle-publication', [NosprojetController::class, 'togglePublication'])->name('nosprojets.toggle-publication');

    // Routes pour les partenaires
    Route::resource('partenaires', PartenaireController::class);
    Route::post('/partenaires/{partenaire}/move-up', [PartenaireController::class, 'moveUp'])->name('partenaires.moveUp');
    Route::post('/partenaires/{partenaire}/move-down', [PartenaireController::class, 'moveDown'])->name('partenaires.moveDown');
    Route::get('/partenaires/{partenaire}/toggle-publication', [PartenaireController::class, 'togglePublication'])->name('partenaires.togglePublication');

    // Routes pour la gestion des utilisateurs
    Route::resource('users', \App\Http\Controllers\UserController::class);
    Route::get('/users/{user}/toggle-status', [\App\Http\Controllers\UserController::class, 'toggleStatus'])->name('users.toggle-status');

    // Routes pour la gestion des rôles
    Route::resource('roles', \App\Http\Controllers\RoleController::class);
    Route::get('/roles/{role}/toggle-status', [\App\Http\Controllers\RoleController::class, 'toggleStatus'])->name('roles.toggle-status');
    Route::post('/roles/{role}/move-up', [\App\Http\Controllers\RoleController::class, 'moveUp'])->name('roles.moveUp');
    Route::post('/roles/{role}/move-down', [\App\Http\Controllers\RoleController::class, 'moveDown'])->name('roles.moveDown');

    // Routes pour la gestion des permissions
    Route::resource('permissions', \App\Http\Controllers\PermissionController::class);
    Route::get('/permissions/{permission}/toggle-status', [\App\Http\Controllers\PermissionController::class, 'toggleStatus'])->name('permissions.toggle-status');
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [\App\Http\Controllers\ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [\App\Http\Controllers\ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [\App\Http\Controllers\ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Routes pour les témoignages
Route::prefix('admin')->name('admin.')->group(function () {
    Route::resource('temoinages', \App\Http\Controllers\TemoinageController::class);
    Route::get('temoinages/{id}/move-up', [\App\Http\Controllers\TemoinageController::class, 'moveUp'])->name('temoinages.moveUp');
    Route::get('temoinages/{id}/move-down', [\App\Http\Controllers\TemoinageController::class, 'moveDown'])->name('temoinages.moveDown');
    Route::get('temoinages/{id}/toggle-publication', [\App\Http\Controllers\TemoinageController::class, 'togglePublication'])->name('temoinages.togglePublication');
});

// Routes pour nos projets
Route::prefix('admin')->name('admin.')->group(function () {
    Route::resource('nosprojets', \App\Http\Controllers\NosprojetController::class);
    Route::post('/nosprojets/{nosprojet}/move-up', [\App\Http\Controllers\NosprojetController::class, 'moveUp'])->name('nosprojets.moveUp');
    Route::post('/nosprojets/{nosprojet}/move-down', [\App\Http\Controllers\NosprojetController::class, 'moveDown'])->name('nosprojets.moveDown');
    Route::get('/nosprojets/{nosprojet}/toggle-publication', [\App\Http\Controllers\NosprojetController::class, 'togglePublication'])->name('nosprojets.toggle-publication');
});

// Route pour afficher les détails d'un matériau (doit être en dernier)
Route::get('/{categorieSlug}/{matiereSlug}', function ($categorieSlug, $matiereSlug) {
    $categoriematiere = \App\Models\Categoriematiere::where('slug', $categorieSlug)->where('pub', 1)->firstOrFail();
    $matiere = \App\Models\Matiere::where('slug', $matiereSlug)
                                 ->where('categoriematiere_id', $categoriematiere->id)
                                 ->where('pub', 1)
                                 ->firstOrFail();
    return view('materiau.detail', compact('matiere'));
})->name('materiau.detail');
Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');