
<!DOCTYPE html>
<html lang="fr">
	<head>
		<title>Connexion - Administration Granit</title>
		<meta charset="utf-8" />
		<meta name="description" content="" />
		<meta name="keywords" content="" />
		<meta name="viewport" content="width=device-width, initial-scale=1" />
		<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
		<link rel="shortcut icon" href="/assets/media/logos/favicon.ico" />
		<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />
		<link href="/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
		<link href="/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
	</head>
	<body id="kt_body" class="app-blank">
		<script>var defaultThemeMode = "light"; var themeMode; if ( document.documentElement ) { if ( document.documentElement.hasAttribute("data-bs-theme-mode")) { themeMode = document.documentElement.getAttribute("data-bs-theme-mode"); } else { if ( localStorage.getItem("data-bs-theme") !== null ) { themeMode = localStorage.getItem("data-bs-theme"); } else { themeMode = defaultThemeMode; } } if (themeMode === "system") { themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light"; } document.documentElement.setAttribute("data-bs-theme", themeMode); }</script>
		
		<div class="d-flex flex-column flex-root" id="kt_app_root">
			<div class="d-flex flex-column flex-lg-row flex-column-fluid">
				<div class="d-flex flex-column flex-lg-row-fluid w-lg-50 p-10 order-2 order-lg-1">
					<div class="d-flex flex-center flex-column flex-lg-row-fluid">
						<div class="w-lg-500px p-10">
							
							<?php if(session('success')): ?>
								<div class="alert alert-success mb-5">
									<?php echo e(session('success')); ?>

								</div>
							<?php endif; ?>

							<?php if($errors->any()): ?>
								<div class="alert alert-danger mb-5">
									<ul class="mb-0">
										<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<li><?php echo e($error); ?></li>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</ul>
								</div>
							<?php endif; ?>

							<form class="form w-100" method="POST" action="<?php echo e(route('login')); ?>" id="kt_sign_in_form">
								<?php echo csrf_field(); ?>
								
								<div class="text-center mb-11">
									<h1 class="text-gray-900 fw-bolder mb-3">Connexion</h1>
									<div class="text-gray-500 fw-semibold fs-6">Administration Granit</div>
								</div>

								<div class="separator separator-content my-14">
									<span class="w-125px text-gray-500 fw-semibold fs-7">Connexion avec email</span>
								</div>

								<div class="fv-row mb-8">
									<input type="email" 
										   placeholder="Adresse email" 
										   name="email" 
										   value="<?php echo e(old('email')); ?>" 
										   autocomplete="email" 
										   class="form-control bg-transparent <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
										   required />
									<?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
										<div class="invalid-feedback d-block"><?php echo e($message); ?></div>
									<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
								</div>

								<div class="fv-row mb-3">
									<input type="password" 
										   placeholder="Mot de passe" 
										   name="password" 
										   autocomplete="current-password" 
										   class="form-control bg-transparent <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
										   required />
									<?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
										<div class="invalid-feedback d-block"><?php echo e($message); ?></div>
									<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
								</div>

								<div class="d-flex flex-stack flex-wrap gap-3 fs-base fw-semibold mb-8">
									<div class="form-check">
										<input class="form-check-input" type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
										<label class="form-check-label" for="remember">
											Se souvenir de moi
										</label>
									</div>
									<?php if(Route::has('password.request')): ?>
										<a href="<?php echo e(route('password.request')); ?>" class="link-primary">Mot de passe oublié ?</a>
									<?php endif; ?>
								</div>

								<div class="d-grid mb-10">
									<button type="submit" id="kt_sign_in_submit" class="btn btn-primary">
										<span class="indicator-label">Se connecter</span>
										<span class="indicator-progress">Veuillez patienter... 
										<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
									</button>
								</div>

								<?php if(Route::has('register')): ?>
									<div class="text-gray-500 text-center fw-semibold fs-6">Pas encore de compte ? 
									<a href="<?php echo e(route('register')); ?>" class="link-primary">S'inscrire</a></div>
								<?php endif; ?>
							</form>
						</div>
					</div>
					
					<div class="w-lg-500px d-flex flex-stack px-10 mx-auto">
						<div class="me-10">
							<button class="btn btn-flex btn-link btn-color-gray-700 btn-active-color-primary rotate fs-base" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-start" data-kt-menu-offset="0px, 0px">
								<img data-kt-element="current-lang-flag" class="w-20px h-20px rounded me-3" src="/assets/media/flags/france.svg" alt="" />
								<span data-kt-element="current-lang-name" class="me-1">Français</span>
								<span class="d-flex flex-center rotate-180">
									<i class="ki-outline ki-down fs-5 text-muted m-0"></i>
								</span>
							</button>
							<div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg-light-primary fw-semibold w-200px py-4 fs-7" data-kt-menu="true" id="kt_auth_lang_menu">
								<div class="menu-item px-3">
									<a href="#" class="menu-link d-flex px-5" data-kt-lang="French">
										<span class="symbol symbol-20px me-4">
											<img data-kt-element="lang-flag" class="rounded-1" src="/assets/media/flags/france.svg" alt="" />
										</span>
										<span data-kt-element="lang-name">Français</span>
									</a>
								</div>
								<div class="menu-item px-3">
									<a href="#" class="menu-link d-flex px-5" data-kt-lang="English">
										<span class="symbol symbol-20px me-4">
											<img data-kt-element="lang-flag" class="rounded-1" src="/assets/media/flags/united-states.svg" alt="" />
										</span>
										<span data-kt-element="lang-name">English</span>
									</a>
								</div>
							</div>
						</div>
						<div class="d-flex fw-semibold text-primary fs-base gap-5">
							<a href="#" target="_blank">Conditions</a>
							<a href="#" target="_blank">Contact</a>
						</div>
					</div>
				</div>
				
				<div class="d-flex flex-lg-row-fluid w-lg-50 bgi-size-cover bgi-position-center order-1 order-lg-2" style="background-image: url(/assets/media/misc/auth-bg.png)">
					<div class="d-flex flex-column flex-center py-7 py-lg-15 px-5 px-md-15 w-100">
						<a href="<?php echo e(url('/')); ?>" class="mb-0 mb-lg-12">
							<img alt="Logo" src="/frontassets/img/logo_eco_granit.png" class="h-60px h-lg-75px" />
						</a>
						<img class="d-none d-lg-block mx-auto w-275px w-md-50 w-xl-500px mb-10 mb-lg-20" src="/assets/media/misc/auth-screens.png" alt="" />
						<h1 class="d-none d-lg-block text-white fs-2qx fw-bolder text-center mb-7">Rapide, Efficace et Productif</h1>
						<div class="d-none d-lg-block text-white fs-base text-center">
							Accédez à votre espace d'administration pour gérer 
							<a href="#" class="opacity-75-hover text-warning fw-bold me-1">vos matières</a>, coloris, devis 
							<br />et toutes les fonctionnalités de votre 
							<a href="#" class="opacity-75-hover text-warning fw-bold me-1">plateforme</a> granit.
						</div>
					</div>
				</div>
			</div>
		</div>

		<script>var hostUrl = "/assets/";</script>
		<script src="/assets/plugins/global/plugins.bundle.js"></script>
		<script src="/assets/js/scripts.bundle.js"></script>
		<script src="/assets/js/custom/authentication/sign-in/general.js"></script>
	</body>
</html>
<?php /**PATH C:\wamp64\www\test\ecogranit\resources\views/auth/login.blade.php ENDPATH**/ ?>