<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-column-fluid">
    <?php if(session('success')): ?>
        <div class="alert alert-dismissible bg-light-success d-flex flex-column flex-sm-row p-5 mb-10">
            <i class="ki-outline ki-shield-tick fs-2hx text-success me-4"></i>
            <div class="d-flex flex-column">
                <h4 class="mb-1 text-success">Succès</h4>
                <span><?php echo e(session('success')); ?></span>
            </div>
            <button type="button" class="position-absolute position-sm-relative m-2 m-sm-0 top-0 end-0 btn btn-icon ms-sm-auto" data-bs-dismiss="alert">
                <i class="ki-outline ki-cross fs-1 text-success"></i>
            </button>
        </div>
    <?php endif; ?>

<div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
    <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
        <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
            <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Gestion des devis</h1>
                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                    <li class="breadcrumb-item text-muted">Espace administration</li>	
                </ul>
            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">
                <a href="<?php echo e(route('admin.devis.create')); ?>" class="btn btn-primary">
                    <i class="ki-outline ki-plus fs-2"></i>
                    Nouveau Devis
                </a>
            </div>
        </div>
    </div>
</div>

 <div id="kt_app_content" class="app-content flex-column-fluid">

<div id="kt_app_content_container" class="app-container container-fluid">
    <!--begin::Category-->
    <div class="card card-flush">
        <!--begin::Card header-->
        <form action="<?php echo e(route('admin.devis.index')); ?>" method="GET" id="devis_filter_form">
            <div style="border-bottom: solid 1px #f5f5f5;" class="mx-10 py-5 mb-5">
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">Mot clés</label>
                        <input type="text" name="search" class="form-control mb-2" placeholder="Rechercher..." value="<?php echo e(request('search')); ?>" />
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Plage de dates</label>
                        <input type="text" id="kt_daterangepicker_1" name="date_range" class="form-control mb-2" placeholder="Sélectionner la plage de dates" value="<?php echo e(request('date_range')); ?>" />
                    </div>



                    <div class="col-md-2">
                        <label class="form-label">Statut</label>
                        <select name="statut" class="form-select" data-hide-search="true" data-control="select2">
                            <option value="">Tous les statuts</option>
                            <option value="0" <?php echo e(request('statut') === '0' ? 'selected' : ''); ?>>En cours</option>
                            <option value="1" <?php echo e(request('statut') === '1' ? 'selected' : ''); ?>>Validé</option>
                            <option value="2" <?php echo e(request('statut') === '2' ? 'selected' : ''); ?>>Confirmé</option>
                            <option value="3" <?php echo e(request('statut') === '3' ? 'selected' : ''); ?>>Annulé</option>
                        </select>
                    </div>
                    <div class="col-md-3">

                    </div>
                    <div class="col-md-1">
                        <button type="submit" class="btn btn-primary mt-8">Rechercher</button>
                    </div>
                </div>


            </div>
        </form>
        <!--end::Card header-->

        <!--begin::Card body-->
        <div class="card-body pt-0">
            <!--begin::Table-->
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_ecommerce_category_table">
                <thead>
                    <tr class="text-start text-muted text-uppercase gs-0">
                        <th class="min-w-100px">No. Devis</th>
                        <th class="min-w-100px">Date</th>
                        <th class="min-w-100px">Client</th>
                        <th>Statut</th>
                        <th>Montant HT</th>
                        <th class="text-end min-w-100px pe-4">Actions</th>
                    </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                    <?php $__empty_1 = true; $__currentLoopData = $devis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $devi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <a href="<?php echo e(route('admin.devis.show', $devi)); ?>" class="text-gray-600 text-hover-primary mb-1">
                                    #<?php echo e(str_pad($devi->id, 6, '0', STR_PAD_LEFT)); ?>

                                </a>
                            </td>

                            <td><?php echo e($devi->created_at->format('d M Y')); ?></td>
                            <td>
                                <?php if($devi->client): ?>
                                    <div><?php echo e($devi->client->nom); ?> <?php echo e($devi->client->prenom); ?></div>
                                    <div class="text-muted fs-7"><?php echo e($devi->client->email); ?></div>
                                    <div class="text-muted fs-7"><?php echo e($devi->client->telephone); ?></div>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php switch($devi->statut):
                                    case (0): ?>
                                        <span class="badge badge-light-primary">En cours</span>
                                        <?php break; ?>
                                    <?php case (1): ?>
                                        <span class="badge badge-light-warning">Validé</span>
                                        <?php break; ?>
                                    <?php case (2): ?>
                                        <span class="badge badge-light-success">Confirmé</span>
                                        <?php break; ?>
                                    <?php case (3): ?>
                                        <span class="badge badge-light-danger">Annulé</span>
                                        <?php break; ?>
                                    <?php default: ?>
                                        <span class="badge badge-light-secondary">Inconnu</span>
                                <?php endswitch; ?>
                            </td>
                            <td><?php echo e(number_format($devi->total_ht, 2, ',', ' ')); ?> €</td>
                            <td class="pe-0 text-end">
                                <div class="d-flex my-3 ms-9">
                                    <div class="ms-auto">
                                        
                                        <a href="<?php echo e(route('admin.devis.edit', $devi)); ?>" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3" data-bs-toggle="tooltip" title="Modifier">
                                            <i class="ki-outline ki-pencil fs-3"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.devis.preview-pdf', $devi)); ?>" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3" target="_blank" title="Prévisualiser PDF">
                                            <i class="ki-outline ki-document fs-3"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.devis.pdf', $devi)); ?>" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3" title="Télécharger PDF">
                                            <i class="ki-outline ki-file-down fs-3"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.devis.destroy', $devi)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer ce devis ?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3" data-bs-toggle="tooltip" title="Supprimer">
                                                <i class="ki-outline ki-trash fs-3"></i>
                                            </button>
                                        </form>

                                      
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-5">
                                <div class="text-muted">Aucun devis trouvé</div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <!--end::Table-->

            <!-- Pagination -->
            <div class="d-flex justify-content-center">
                <?php echo e($devis->appends(request()->query())->links()); ?>

            </div>
        </div>
        <!--end::Card body-->
    </div>
    <!--end::Category-->

    <!-- Montant total -->
    <div class="card pt-4 mb-6 mt-10">
        <div class="card-header border-0">
            <div class="card-title">
                <h2 class="fw-bold">Montant total</h2>
            </div>
        </div>

        <div class="card-body ms-auto pt-0">
            <div class="fw-bold fs-2">
                <?php echo e(number_format($totalAmount, 2, ',', ' ')); ?> €
            </div>
        </div>
    </div>
</div>
 </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script>
$(document).ready(function() {
    // Initialize date range picker
    $("#kt_daterangepicker_1").daterangepicker({
        autoUpdateInput: false,
        locale: {
            cancelLabel: 'Effacer',
            applyLabel: 'Appliquer',
            format: 'DD/MM/YYYY',
            separator: ' - ',
            fromLabel: 'De',
            toLabel: 'À',
            customRangeLabel: 'Personnalisé',
            weekLabel: 'S',
            daysOfWeek: ['Di', 'Lu', 'Ma', 'Me', 'Je', 'Ve', 'Sa'],
            monthNames: ['Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin',
                        'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'],
            firstDay: 1
        },
        ranges: {
            'Aujourd\'hui': [moment(), moment()],
            'Hier': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            '7 derniers jours': [moment().subtract(6, 'days'), moment()],
            '30 derniers jours': [moment().subtract(29, 'days'), moment()],
            'Ce mois': [moment().startOf('month'), moment().endOf('month')],
            'Mois dernier': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    });

    $("#kt_daterangepicker_1").on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('DD/MM/YYYY'));
    });

    $("#kt_daterangepicker_1").on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/workspace/resources/views/admin/devis/index.blade.php ENDPATH**/ ?>