<?php $__env->startSection('content'); ?>

<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Gestion des épaisseurs</h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>	
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="<?php echo e(route('admin.epaisseurs.create')); ?>" class="btn btn-flex btn-primary h-40px fs-7 fw-bold">Ajout</a>
                </div>
            </div>
        </div>
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="card card-flush">
                <div class="card-body pt-0">										
                    <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_ecommerce_category_table">
                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">
                                <th width="15%" class="min-w-100px">Photo</th>
                                <th width="55%" class="min-w-410px">Titre</th>
                                <th width="15%" class="max-w-70px">Ordre</th>
                                <th width="15%" class="text-end max-w-70px">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="fw-semibold text-gray-600">
                            <?php $__currentLoopData = $epaisseurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $epaisseur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($epaisseur->photo): ?>
                                        <img src="<?php echo e(asset('storage/' . $epaisseur->photo)); ?>" alt="Photo" class="w-50px h-50px rounded">
                                    <?php else: ?>
                                        <span class="text-muted">Aucune photo</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($epaisseur->titre); ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="d-flex">
                                            <?php if($epaisseur->ordre < $epaisseurs->max('ordre')): ?>
                                            <form action="<?php echo e(route('admin.epaisseurs.moveUp', $epaisseur)); ?>" method="POST" class="me-1">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-icon btn-active-light-primary w-20px h-20px" data-bs-toggle="tooltip" title="Déplacer vers le haut">
                                                    <i class="ki-outline ki-arrow-up fs-6"></i>
                                                </button>
                                            </form>
                                            <?php else: ?>
                                            <div class="me-1" style="width: 20px;"></div>
                                            <?php endif; ?>
                                            <?php if($epaisseur->ordre > $epaisseurs->min('ordre')): ?>
                                            <form action="<?php echo e(route('admin.epaisseurs.moveDown', $epaisseur)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-icon btn-active-light-primary w-20px h-20px" data-bs-toggle="tooltip" title="Déplacer vers le bas">
                                                    <i class="ki-outline ki-arrow-down fs-6"></i>
                                                </button>
                                            </form>
                                            <?php else: ?>
                                            <div style="width: 20px;"></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex my-3 ms-9">
                                        <div class="ms-auto">
                                            <a href="<?php echo e(route('admin.epaisseurs.toggle-publication', $epaisseur)); ?>" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3" data-bs-toggle="tooltip" title="<?php echo e($epaisseur->pub ? 'Dépublier' : 'Publier'); ?>">
                                                <i style="color:<?php echo e($epaisseur->pub ? 'green' : 'red'); ?>" class="ki-outline <?php echo e($epaisseur->pub ? 'ki-check' : 'ki-cross'); ?> fs-1"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.epaisseurs.edit', $epaisseur)); ?>" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3">
                                                <span data-bs-toggle="tooltip" data-bs-trigger="hover" title="Edit">
                                                    <i class="ki-outline text-warning ki-pencil fs-3"></i>
                                                </span>
                                            </a>
                                            <form action="<?php echo e(route('admin.epaisseurs.destroy', $epaisseur)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-icon btn-active-light-primary w-30px h-30px" data-bs-toggle="tooltip" title="Supression" onclick="return confirm('Voulez-vous continue la supression ?')">
                                                    <i class="ki-outline text-danger ki-trash fs-3"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($epaisseurs->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/workspace/resources/views/admin/epaisseurs/index.blade.php ENDPATH**/ ?>