<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">
                        Gestion des coloris 
                        <?php if($selectedMatiere): ?> 
                        - <?php echo e($selectedMatiere->titre); ?>

                        <?php endif; ?>

                    </h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="<?php echo e(route('admin.matieres.index')); ?>" class="btn btn-flex btn-outline btn-color-gray-700 btn-active-color-primary bg-body h-40px fs-7 fw-bold">Liste des matières</a>
                    <a href="<?php echo e(route('admin.coloris.create')); ?><?php echo e(request('matiere_id') ? '?matiere_id=' . request('matiere_id') : ''); ?>" class="btn btn-flex btn-primary h-40px fs-7 fw-bold">Ajout</a>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            <?php if(session('success')): ?>
                <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-shield-tick fs-2hx text-success me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-success">Succès</h4>
                        <span><?php echo e(session('success')); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-information-5 fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreur</h4>
                        <span><?php echo e(session('error')); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-information-5 fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreur</h4>
                        <span><?php echo e($errors->first()); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <div class="card card-flush mb-5">
                <div class="card-header align-items-center py-5 gap-2 gap-md-5">
                    <div class="card-title">
                        <div class="d-flex align-items-center position-relative my-1">
                            <i class="ki-outline ki-magnifier fs-3 position-absolute ms-4"></i>
                            <select id="matiere-filter" class="form-select w-250px ps-12" onchange="filterByMatiere()">
                                <?php
                                    $matieres = \App\Models\Matiere::orderBy('titre')->get();
                                ?>
                                <?php $__currentLoopData = $matieres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matiere): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($matiere->id); ?>" <?php echo e(request('matiere_id') == $matiere->id ? 'selected' : ''); ?>>
                                        <?php echo e($matiere->titre); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card card-flush">
                <div class="card-body pt-0">
                    <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_ecommerce_category_table">
                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">
                                <th width="15%" class="min-w-100px">Photo</th>
                                <th width="35%" class="min-w-200px">Titre</th>
                                <th width="20%" class="min-w-150px">Matière</th>
                                <th width="15%" class="max-w-70px">Ordre</th>
                                <th width="15%" class="text-end max-w-70px">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="fw-semibold text-gray-600">
                            <?php $__currentLoopData = $coloris; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colori): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($colori->photo): ?>
                                        <img src="<?php echo e(asset('storage/' . $colori->photo)); ?>" alt="Photo" class="w-50px h-50px rounded">
                                    <?php else: ?>
                                        <span class="text-muted">Aucune photo</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($colori->titre); ?></td>
                                <td><?php echo e($colori->matiere->titre ?? 'N/A'); ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="d-flex">
                                            <?php
                                                $maxOrdreMatiere = $coloris->where('matiere_id', $colori->matiere_id)->max('ordre');
                                                $minOrdreMatiere = $coloris->where('matiere_id', $colori->matiere_id)->min('ordre');
                                            ?>
                                            <?php if($colori->ordre < $maxOrdreMatiere): ?>
                                            <form action="<?php echo e(route('admin.coloris.moveUp', $colori)); ?>" method="POST" class="me-1">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-icon btn-active-light-primary w-20px h-20px" data-bs-toggle="tooltip" title="Déplacer vers le haut">
                                                    <i class="ki-outline ki-arrow-up fs-6"></i>
                                                </button>
                                            </form>
                                            <?php else: ?>
                                            <div class="me-1" style="width: 20px;"></div>
                                            <?php endif; ?>
                                            <?php if($colori->ordre > $minOrdreMatiere): ?>
                                            <form action="<?php echo e(route('admin.coloris.moveDown', $colori)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-icon btn-active-light-primary w-20px h-20px" data-bs-toggle="tooltip" title="Déplacer vers le bas">
                                                    <i class="ki-outline ki-arrow-down fs-6"></i>
                                                </button>
                                            </form>
                                            <?php else: ?>
                                            <div style="width: 20px;"></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex my-3 ms-9">
                                        <div class="ms-auto">
                                            <a href="<?php echo e(route('admin.coloris.toggle-publication', $colori)); ?>" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3" data-bs-toggle="tooltip" title="<?php echo e($colori->pub ? 'Dépublier' : 'Publier'); ?>">
                                                <i style="color:<?php echo e($colori->pub ? 'green' : 'red'); ?>" class="ki-outline <?php echo e($colori->pub ? 'ki-check' : 'ki-cross'); ?> fs-1"></i>
                                            </a>

                                            <a href="<?php echo e(route('admin.coloris.edit', $colori)); ?>" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3">
                                                <span data-bs-toggle="tooltip" data-bs-trigger="hover" title="Edit">
                                                    <i class="ki-outline text-warning ki-pencil fs-3"></i>
                                                </span>
                                            </a>

                                            <form action="<?php echo e(route('admin.coloris.destroy', $colori)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-icon btn-active-light-primary w-30px h-30px" data-bs-toggle="tooltip" title="Suppression" onclick="return confirm('Voulez-vous continuer la suppression ?')">
                                                    <i class="ki-outline text-danger ki-trash fs-3"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($coloris->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
function filterByMatiere() {
    const select = document.getElementById('matiere-filter');
    const matiereId = select.value;

    window.location.href = '<?php echo e(route("admin.coloris.index")); ?>?matiere_id=' + matiereId;
}
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\test\ecogranit\resources\views/admin/coloris/index.blade.php ENDPATH**/ ?>