<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">
                        <?php echo e(isset($post) ? 'Modifier Post' : 'Ajout Post'); ?>

                    </h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="<?php echo e(route('admin.posts.index')); ?>" class="btn btn-flex btn-outline btn-color-gray-700 btn-active-color-primary bg-body h-40px fs-7 fw-bold">Liste</a>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            <?php if(session('success')): ?>
                <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-shield-tick fs-2hx text-success me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-success">Succès</h4>
                        <span><?php echo e(session('success')); ?></span>
                    </div>
                </div>
            <?php endif; ?>
            
            <?php if($errors->any()): ?>
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-cross-circle fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreurs de validation</h4>
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            <?php endif; ?>

            <form class="form d-flex flex-column flex-lg-row" 
                  action="<?php echo e(isset($post) ? route('admin.posts.update', $post) : route('admin.posts.store')); ?>" 
                  method="POST">
                <?php echo csrf_field(); ?>
                <?php if(isset($post)): ?>
                    <?php echo method_field('PUT'); ?>
                <?php endif; ?>
                
                <div class="d-flex flex-column gap-7 gap-lg-10 w-100 w-lg-300px mb-7 me-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Status</h2>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <select name="pub" class="form-select mb-2">
                                <option value="1" <?php echo e(isset($post) && $post->pub ? 'selected' : ''); ?>>Publié</option>
                                <option value="0" <?php echo e(isset($post) && !$post->pub ? 'selected' : ''); ?>>Brouillon</option>
                            </select>
                            <div class="text-muted fs-7">Sélectionner le statut du post.</div>
                        </div>
                    </div>

                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Catégorie</h2>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <select name="category_id" class="form-select mb-2" required>
                                <option value="">Sélectionner une catégorie</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" <?php echo e(isset($post) && $post->category_id == $category->id ? 'selected' : ''); ?>>
                                        <?php echo e($category->title); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="text-muted fs-7">Sélectionner la catégorie du post.</div>
                        </div>
                    </div>
                </div>

                <div class="d-flex flex-column flex-row-fluid gap-7 gap-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>General</h2>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <div class="mb-10 fv-row">
                                <label class="required form-label">Titre</label>
                                <input type="text" name="title" class="form-control mb-2" placeholder="Titre du post" 
                                       value="<?php echo e(isset($post) ? $post->title : old('title')); ?>" required />
                                <div class="text-muted fs-7">Ce champ est requis.</div>
                            </div>
                            
                            <div class="mb-10 fv-row">
                                <label class="required form-label">Contenu</label>
                                <textarea name="content" class="form-control mb-2" rows="15" placeholder="Contenu du post" required><?php echo e(isset($post) ? $post->content : old('content')); ?></textarea>
                                <div class="text-muted fs-7">Contenu du post.</div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end">
                        <a href="<?php echo e(route('admin.posts.index')); ?>" class="btn btn-light me-5">Annuler</a>
                        <button type="submit" class="btn btn-primary">
                            <?php echo e(isset($post) ? 'Modifier' : 'Ajouter'); ?>

                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/workspace/resources/views/admin/posts/form.blade.php ENDPATH**/ ?>