<?php $__env->startSection('title', $matiere->meta_title ?: $matiere->titre); ?>
<?php $__env->startSection('meta_description', $matiere->meta_description ?: $matiere->description); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-lg-12">
            <div class="page-header">
                <h1 class="page-title"><?php echo e($matiere->titre); ?></h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Accueil</a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($matiere->titre); ?></li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-6">
            <?php if($matiere->photo): ?>
                <div class="matiere-image">
                    <img src="<?php echo e(asset('storage/' . $matiere->photo)); ?>" alt="<?php echo e($matiere->titre); ?>" class="img-fluid">
                </div>
            <?php endif; ?>
        </div>
        
        <div class="col-lg-6">
            <div class="matiere-content">
                <h2><?php echo e($matiere->titre); ?></h2>
                
                <?php if($matiere->categoriematiere): ?>
                    <p><strong>Catégorie :</strong> <?php echo e($matiere->categoriematiere->titre); ?></p>
                <?php endif; ?>
                
                <?php if($matiere->description): ?>
                    <div class="matiere-description">
                        <h3>Description</h3>
                        <p><?php echo e($matiere->description); ?></p>
                    </div>
                <?php endif; ?>

                <?php if($matiere->logo): ?>
                    <div class="matiere-logo mt-4">
                        <img src="<?php echo e(asset('storage/' . $matiere->logo)); ?>" alt="Logo <?php echo e($matiere->titre); ?>" class="img-fluid" style="max-height: 100px;">
                    </div>
                <?php endif; ?>

                <div class="mt-4">
                    <a href="<?php echo e(url('/contact')); ?>" class="ecogranit-btn-devis">
                        <span>Demander un devis</span>
                        <i class="icon-right-arrow"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <?php if($matiere->coloris->count() > 0): ?>
    <div class="row mt-5">
        <div class="col-lg-12">
            <h3>Coloris disponibles</h3>
            <div class="row">
                <?php $__currentLoopData = $matiere->coloris; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colori): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4 mb-3">
                        <div class="colori-card">
                            <?php if($colori->photo): ?>
                                <img src="<?php echo e(asset('storage/' . $colori->photo)); ?>" alt="<?php echo e($colori->titre); ?>" class="img-fluid">
                            <?php endif; ?>
                            <h5><?php echo e($colori->titre); ?></h5>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/workspace/resources/views/materiau/detail.blade.php ENDPATH**/ ?>