<?php $__env->startSection('title', 'Détails de l\'utilisateur'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                <h1 class="page-heading d-flex text-gray-900 fw-bold fs-3 flex-column justify-content-center my-0">Détails de l'utilisateur</h1>
                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                    <li class="breadcrumb-item text-muted">
                        <a href="<?php echo e(route('admin.users.index')); ?>" class="text-muted text-hover-primary">Utilisateurs</a>
                    </li>
                    <li class="breadcrumb-item">
                        <span class="bullet bg-gray-500 w-5px h-2px"></span>
                    </li>
                    <li class="breadcrumb-item text-muted"><?php echo e($user->name); ?></li>
                </ul>
            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">
                <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="btn btn-sm fw-bold btn-primary">
                    <i class="ki-outline ki-pencil fs-2"></i>Modifier
                </a>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">

            <div class="card mb-5 mb-xl-10">
                <div class="card-body pt-9 pb-0">
                    <div class="d-flex flex-wrap flex-sm-nowrap">
                        <div class="me-7 mb-4">
                            <div class="symbol symbol-100px symbol-lg-160px symbol-fixed position-relative">
                                <img src="/assets/media/avatars/300-1.jpg" alt="image" />
                            </div>
                        </div>

                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                                <div class="d-flex flex-column">
                                    <div class="d-flex align-items-center mb-2">
                                        <span class="text-gray-900 text-hover-primary fs-2 fw-bold me-1"><?php echo e($user->name); ?></span>
                                        <?php if($user->is_active): ?>
                                            <span class="badge badge-light-success me-auto">Actif</span>
                                        <?php else: ?>
                                            <span class="badge badge-light-danger me-auto">Inactif</span>
                                        <?php endif; ?>
                                    </div>

                                    <div class="d-flex flex-wrap fw-semibold fs-6 mb-4 pe-2">
                                        <span class="d-flex align-items-center text-gray-500 me-5 mb-2">
                                            <i class="ki-outline ki-sms fs-4 me-1"></i><?php echo e($user->email); ?>

                                        </span>
                                        <span class="d-flex align-items-center text-gray-500 me-5 mb-2">
                                            <i class="ki-outline ki-calendar fs-4 me-1"></i>Inscrit le <?php echo e($user->created_at->format('d/m/Y')); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                        <li class="nav-item mt-2">
                            <a class="nav-link text-active-primary ms-0 me-10 py-5 active" href="#kt_tab_pane_1" data-bs-toggle="tab">Informations</a>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="card mb-5 mb-xl-10">
                <div class="card-header cursor-pointer">
                    <div class="card-title m-0">
                        <h3 class="fw-bold m-0">Informations de l'utilisateur</h3>
                    </div>
                </div>

                <div class="card-body p-9">
                    <div class="row mb-7">
                        <label class="col-lg-4 fw-semibold text-muted">Nom complet</label>
                        <div class="col-lg-8">
                            <span class="fw-bold fs-6 text-gray-800"><?php echo e($user->name); ?></span>
                        </div>
                    </div>

                    <div class="row mb-7">
                        <label class="col-lg-4 fw-semibold text-muted">Email</label>
                        <div class="col-lg-8 fv-row">
                            <span class="fw-semibold text-gray-800 fs-6"><?php echo e($user->email); ?></span>
                        </div>
                    </div>

                    <div class="row mb-7">
                        <label class="col-lg-4 fw-semibold text-muted">Statut</label>
                        <div class="col-lg-8 d-flex align-items-center">
                            <?php if($user->is_active): ?>
                                <span class="badge badge-light-success">Actif</span>
                            <?php else: ?>
                                <span class="badge badge-light-danger">Inactif</span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="row mb-7">
                        <label class="col-lg-4 fw-semibold text-muted">Date d'inscription</label>
                        <div class="col-lg-8">
                            <span class="fw-bold fs-6 text-gray-800"><?php echo e($user->created_at->format('d/m/Y H:i')); ?></span>
                        </div>
                    </div>

                    <div class="row mb-7">
                        <label class="col-lg-4 fw-semibold text-muted">Dernière modification</label>
                        <div class="col-lg-8">
                            <span class="fw-bold fs-6 text-gray-800"><?php echo e($user->updated_at->format('d/m/Y H:i')); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/workspace/resources/views/admin/users/show.blade.php ENDPATH**/ ?>