<?php $__env->startSection('title', 'Gestion des Rôles'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                <h1 class="page-heading d-flex text-gray-900 fw-bold fs-3 flex-column justify-content-center my-0">Gestion des Rôles</h1>
            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">
                <a href="<?php echo e(route('admin.roles.create')); ?>" class="btn btn-sm fw-bold btn-primary">
                    <i class="ki-outline ki-plus fs-2"></i>Nouveau Rôle
                </a>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">

            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header border-0 pt-6">
                    <div class="card-title">
                        <div class="d-flex align-items-center position-relative my-1">
                            <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i>
                            <input type="text" data-kt-roles-table-filter="search" class="form-control form-control-solid w-250px ps-13" placeholder="Rechercher un rôle" />
                        </div>
                    </div>
                </div>

                <div class="card-body py-4">
                    <div class="table-responsive">
                        <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_roles">
                            <thead>
                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                    <th class="min-w-125px">Rôle</th>
                                    <th class="min-w-125px">Nom technique</th>
                                    <th class="min-w-125px">Permissions</th>
                                    <th class="min-w-100px">Utilisateurs</th>
                                    <th class="min-w-100px">Statut</th>
                                    <th class="min-w-100px">Ordre</th>
                                    <th class="text-end min-w-100px">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-semibold">
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="text-gray-800 fw-bold"><?php echo e($role->display_name); ?></span>
                                            <?php if($role->description): ?>
                                                <span class="text-muted fs-7"><?php echo e(Str::limit($role->description, 50)); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-light-primary"><?php echo e($role->name); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge badge-light-info"><?php echo e($role->permissions->count()); ?> permissions</span>
                                    </td>
                                    <td>
                                        <span class="badge badge-light-warning"><?php echo e($role->users->count()); ?> utilisateurs</span>
                                    </td>
                                    <td>
                                        <?php if($role->is_active): ?>
                                            <span class="badge badge-light-success">Actif</span>
                                        <?php else: ?>
                                            <span class="badge badge-light-danger">Inactif</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="me-2"><?php echo e($role->ordre); ?></span>
                                            <div class="btn-group" role="group">
                                                <form action="<?php echo e(route('admin.roles.moveUp', $role)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-sm btn-light-primary" title="Monter">
                                                        <i class="ki-outline ki-up fs-7"></i>
                                                    </button>
                                                </form>
                                                <form action="<?php echo e(route('admin.roles.moveDown', $role)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-sm btn-light-primary" title="Descendre">
                                                        <i class="ki-outline ki-down fs-7"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.roles.show', $role)); ?>" class="btn btn-sm btn-light-info" title="Voir">
                                                <i class="ki-outline ki-eye fs-7"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.roles.edit', $role)); ?>" class="btn btn-sm btn-light-primary" title="Modifier">
                                                <i class="ki-outline ki-pencil fs-7"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.roles.toggle-status', $role)); ?>" class="btn btn-sm btn-light-warning" title="Activer/Désactiver">
                                                <i class="ki-outline ki-switch fs-7"></i>
                                            </a>
                                            <?php if($role->users->count() == 0): ?>
                                                <form action="<?php echo e(route('admin.roles.destroy', $role)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer ce rôle ?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-light-danger" title="Supprimer">
                                                        <i class="ki-outline ki-trash fs-7"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <?php echo e($roles->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\test\ecogranit\resources\views/admin/roles/index.blade.php ENDPATH**/ ?>