<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Gestion des marques d'accessoires</h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="<?php echo e(route('admin.accessoiremarques.create')); ?>" class="btn btn-flex btn-primary h-40px fs-7 fw-bold">Ajout</a>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="card card-flush">
                <div class="card-body pt-0">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                            <i class="ki-outline ki-shield-tick fs-2hx text-success me-4"></i>
                            <div class="d-flex flex-column">
                                <h4 class="mb-1 text-success">Succès</h4>
                                <span><?php echo e(session('success')); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                            <i class="ki-outline ki-cross-circle fs-2hx text-danger me-4"></i>
                            <div class="d-flex flex-column">
                                <h4 class="mb-1 text-danger">Erreur</h4>
                                <span><?php echo e(session('error')); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if(session('info')): ?>
                        <div class="alert alert-info d-flex align-items-center p-5 mb-10">
                            <i class="ki-outline ki-information fs-2hx text-info me-4"></i>
                            <div class="d-flex flex-column">
                                <h4 class="mb-1 text-info">Information</h4>
                                <span><?php echo e(session('info')); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                    <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_ecommerce_category_table">
                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">
                                <th width="15%" class="min-w-100px">Photo</th>
                                <th width="55%" class="min-w-410px">Titre</th>
                                <th width="15%" class="max-w-70px">Ordre</th>
                                <th width="15%" class="text-end max-w-70px">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="fw-semibold text-gray-600">
                            <?php $__currentLoopData = $accessoiremarques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accessoiremarque): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($accessoiremarque->photo): ?>
                                        <img src="<?php echo e(asset('storage/' . $accessoiremarque->photo)); ?>" alt="Photo" class="w-50px h-50px rounded">
                                    <?php else: ?>
                                        <span class="text-muted">Aucune photo</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($accessoiremarque->titre); ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="d-flex">
                                            <?php if($accessoiremarque->ordre < $accessoiremarques->max('ordre')): ?>
                                            <form action="<?php echo e(route('admin.accessoiremarques.moveUp', $accessoiremarque)); ?>" method="POST" class="me-1">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-icon btn-active-light-primary w-20px h-20px" data-bs-toggle="tooltip" title="Déplacer vers le haut">
                                                    <i class="ki-outline ki-arrow-up fs-6"></i>
                                                </button>
                                            </form>
                                            <?php else: ?>
                                            <div class="me-1" style="width: 20px;"></div>
                                            <?php endif; ?>
                                            <?php if($accessoiremarque->ordre > $accessoiremarques->min('ordre')): ?>
                                            <form action="<?php echo e(route('admin.accessoiremarques.moveDown', $accessoiremarque)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-icon btn-active-light-primary w-20px h-20px" data-bs-toggle="tooltip" title="Déplacer vers le bas">
                                                    <i class="ki-outline ki-arrow-down fs-6"></i>
                                                </button>
                                            </form>
                                            <?php else: ?>
                                            <div style="width: 20px;"></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex my-3 ms-9">
                                        <div class="ms-auto">
                                            <a href="<?php echo e(route('admin.accessoiremarques.toggle-publication', $accessoiremarque->id)); ?>" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3" data-bs-toggle="tooltip" title="<?php echo e($accessoiremarque->pub ? 'Dépublier' : 'Publier'); ?>">
                                                <i style="color:<?php echo e($accessoiremarque->pub ? 'green' : 'red'); ?>" class="ki-outline <?php echo e($accessoiremarque->pub ? 'ki-check' : 'ki-cross'); ?> fs-1"></i>
                                            </a>

                                            <a href="<?php echo e(route('admin.accessoiremarques.edit', $accessoiremarque)); ?>" class="btn btn-icon btn-active-light-primary w-30px h-30px me-3">
                                                <span data-bs-toggle="tooltip" data-bs-trigger="hover" title="Edit">
                                                    <i class="ki-outline text-warning ki-pencil fs-3"></i>
                                                </span>
                                            </a>

                                            <form action="<?php echo e(route('admin.accessoiremarques.destroy', $accessoiremarque)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-icon btn-active-light-primary w-30px h-30px" data-bs-toggle="tooltip" title="Supression" onclick="return confirm('Voulez-vous continue la supression ?')">
                                                    <i class="ki-outline text-danger ki-trash fs-3"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($accessoiremarques->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/workspace/resources/views/admin/accessoiremarques/index.blade.php ENDPATH**/ ?>