<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">
                        <?php echo e(isset($partenaire) ? 'Modifier Partenaire' : 'Ajout Partenaire'); ?>

                    </h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="<?php echo e(route('admin.partenaires.index')); ?>" class="btn btn-flex btn-outline btn-color-gray-700 btn-active-color-primary bg-body h-40px fs-7 fw-bold">Liste</a>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            <?php if(session('success')): ?>
                <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-shield-tick fs-2hx text-success me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-success">Succès</h4>
                        <span><?php echo e(session('success')); ?></span>
                    </div>
                </div>
            <?php endif; ?>
            
            <?php if($errors->any()): ?>
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-cross-circle fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreurs de validation</h4>
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            <?php endif; ?>
            <form id="kt_ecommerce_add_category_form" class="form d-flex flex-column flex-lg-row" 
                  action="<?php echo e(isset($partenaire) ? route('admin.partenaires.update', $partenaire) : route('admin.partenaires.store')); ?>" 
                  method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php if(isset($partenaire)): ?>
                    <?php echo method_field('PUT'); ?>
                <?php endif; ?>
                
                <div class="d-flex flex-column gap-7 gap-lg-10 w-100 w-lg-300px mb-7 me-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Photo</h2>
                            </div>
                        </div>
                        <div class="card-body text-center pt-0">
                            <div class="image-input image-input-empty image-input-outline image-input-placeholder mb-3" data-kt-image-input="true">
                                <div class="image-input-wrapper w-150px h-150px" style="background-image: url(<?php echo e(isset($partenaire) && $partenaire->photo ? asset('storage/' . $partenaire->photo) : ''); ?>)"></div>
                                <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Photo du partenaire">
                                    <i class="ki-outline ki-pencil fs-7"></i>
                                    <input type="file" name="photo" accept=".png,.jpg,.jpeg" />
                                    <input type="hidden" name="avatar_remove" />
                                </label>
                                <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Annuler photo">
                                    <i class="ki-outline ki-cross fs-2"></i>
                                </span>
                                <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Effacer photo">
                                    <i class="ki-outline ki-cross fs-2"></i>
                                </span>
                            </div>
                            <div class="text-muted fs-7">Seuls les fichiers *.png, *.jpg et *.jpeg sont acceptés.</div>
                        </div>
                    </div>
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>Status</h2>
                            </div>
                            <div class="card-toolbar">
                                <div class="rounded-circle <?php echo e(isset($partenaire) && $partenaire->pub ? 'bg-success' : 'bg-danger'); ?> w-15px h-15px" id="kt_ecommerce_add_category_status"></div>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <select name="pub" class="form-select mb-2" id="kt_ecommerce_add_category_status_select">
                                <option value="1" <?php echo e(isset($partenaire) && $partenaire->pub ? 'selected' : ''); ?>>Publié</option>
                                <option value="0" <?php echo e(isset($partenaire) && !$partenaire->pub ? 'selected' : ''); ?>>Non publié</option>
                            </select>
                            <div class="text-muted fs-7">Sélectionner le statut du partenaire.</div>
                        </div>
                    </div>
                </div>

                <div class="d-flex flex-column flex-row-fluid gap-7 gap-lg-10">
                    <div class="card card-flush py-4">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>General</h2>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <div class="mb-10 fv-row">
                                <label class="required form-label">Titre</label>
                                <input type="text" name="titre" class="form-control mb-2" placeholder="Titre" 
                                       value="<?php echo e(isset($partenaire) ? $partenaire->titre : old('titre')); ?>" required />
                                <div class="text-muted fs-7">Ce champs est requis.</div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end">
                        <a href="<?php echo e(route('admin.partenaires.index')); ?>" class="btn btn-light me-5">Annuler</a>
                        <button type="submit" class="btn btn-primary">
                            <?php echo e(isset($partenaire) ? 'Modifier' : 'Ajouter'); ?>

                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const statusSelect = document.getElementById('kt_ecommerce_add_category_status_select');
    const statusCircle = document.getElementById('kt_ecommerce_add_category_status');
    
    if (statusSelect && statusCircle) {
        // Fonction pour mettre à jour la couleur du cercle
        function updateStatusCircle() {
            const selectedValue = statusSelect.value;
            
            // Retirer les classes existantes
            statusCircle.classList.remove('bg-success', 'bg-danger');
            
            // Ajouter la classe appropriée selon le statut
            if (selectedValue === '1') {
                statusCircle.classList.add('bg-success'); // Vert pour publié
            } else {
                statusCircle.classList.add('bg-danger'); // Rouge pour non publié
            }
        }
        
        // Écouter le changement de sélection
        statusSelect.addEventListener('change', updateStatusCircle);
        
        // Initialiser la couleur au chargement de la page
        updateStatusCircle();
    }
});
</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/workspace/resources/views/admin/partenaires/form.blade.php ENDPATH**/ ?>