
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Devis <?php echo e($devi->id); ?></title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #2E7D32;
            padding-bottom: 20px;
            position: relative;
        }
        .header .logo {
            max-height: 60px;
            margin-bottom: 10px;
        }
        .header h1 {
            color: #2E7D32;
            font-size: 24px;
            margin: 0;
        }
        .header h2 {
            color: #4CAF50;
            font-size: 18px;
            margin: 5px 0;
        }
        .company-info {
            text-align: center;
            margin-bottom: 20px;
            font-size: 10px;
        }
        .devis-info {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }
        .client-info, .devis-details {
            display: table-cell;
            width: 50%;
            vertical-align: top;
            padding: 0 10px;
        }
        .client-info {
            border-right: 1px solid #ddd;
        }
        .info-box {
            border: 1px solid #ddd;
            padding: 15px;
            margin-bottom: 10px;
            background-color: #f9f9f9;
        }
        .info-box h3 {
            margin: 0 0 10px 0;
            color: #2E7D32;
            font-size: 14px;
            border-bottom: 1px solid #4CAF50;
            padding-bottom: 5px;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .table th {
            background-color: #2E7D32;
            color: white;
            font-weight: bold;
        }
        .table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .table .text-right {
            text-align: right;
        }
        .total-section {
            margin-top: 20px;
            text-align: right;
        }
        .total-box {
            display: inline-block;
            border: 2px solid #2E7D32;
            padding: 15px;
            background-color: #f0f0f0;
        }
        .total-box .total-ht {
            font-size: 14px;
            margin-bottom: 5px;
        }
        .total-box .total-ttc {
            font-size: 16px;
            font-weight: bold;
            color: #2E7D32;
        }
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            font-size: 10px;
            text-align: center;
        }
        .material-info {
            background-color: #f5f5f5;
            padding: 10px;
            margin: 10px 0;
            border-left: 4px solid #4CAF50;
        }
    </style>
</head>
<body>
    <div class="header">
        <?php
            $logoPath = public_path('frontassets/img/logo_eco_granit.png');
            if (!file_exists($logoPath)) {
                $logoPath = public_path('assets/media/logos/default.svg');
            }
        ?>
        <?php if(file_exists($logoPath)): ?>
            <img src="<?php echo e($logoPath); ?>" alt="ECOGRANIT Logo" class="logo">
        <?php else: ?>
            <div style="height: 60px; display: flex; align-items: center; justify-content: center; background: #f0f0f0; margin-bottom: 10px;">
                <span style="font-weight: bold; color: #666;">ECOGRANIT</span>
            </div>
        <?php endif; ?>
        <h1>ECOGRANIT</h1>
        <h2>DEVIS N° <?php echo e($devi->id); ?></h2>
    </div>

    <div class="company-info">
        <p><strong>ECOGRANIT</strong> - Plans de travail sur mesure<br>
        Adresse de l'entreprise - Téléphone - Email<br>
        SIRET: 000 000 000 00000 - TVA: FR00000000000</p>
    </div>

    <div class="devis-info">
        <div class="client-info">
            <div class="info-box">
                <h3>INFORMATIONS CLIENT</h3>
                <p><strong><?php echo e($devi->client->prenom); ?> <?php echo e($devi->client->nom); ?></strong></p>
                <p><?php echo e($devi->client->adresse); ?></p>
                <p><?php echo e($devi->client->code_postal); ?> <?php echo e($devi->client->ville); ?></p>
                <p>Tél: <?php echo e($devi->client->telephone); ?></p>
                <p>Email: <?php echo e($devi->client->email); ?></p>
            </div>
        </div>
        
        <div class="devis-details">
            <div class="info-box">
                <h3>DÉTAILS DU DEVIS</h3>
                <p><strong>Date:</strong> <?php echo e($dateGeneration); ?></p>
                <p><strong>Validité:</strong> 30 jours</p>
                <p><strong>TVA:</strong> <?php echo e($devi->tva); ?>%</p>
            </div>
        </div>
    </div>

    <div class="material-info">
        <h3>MATÉRIAUX SÉLECTIONNÉS</h3>
        <p><strong>Matière:</strong> <?php echo e($devi->matiere->titre); ?></p>
        <p><strong>Coloris:</strong> <?php echo e($devi->colori->titre); ?></p>
        <p><strong>Finition:</strong> <?php echo e($devi->finition->titre); ?></p>
        <p><strong>Bordure:</strong> <?php echo e($devi->bordure->titre ?? 'Standard'); ?></p>
    </div>

    <?php if($devi->prixcoloris->count() > 0): ?>
    <h3>PLANS DE TRAVAIL ET CRÉDENCES</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Type</th>
                <th>Longueur (mm)</th>
                <th>Largeur (mm)</th>
                <th>Épaisseur</th>
                <th>Surface (m²)</th>
                <th class="text-right">Prix unitaire</th>
                <th class="text-right">Montant</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $devi->prixcoloris; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($item->type == 'pldt' ? 'Plan de travail' : 'Crédence'); ?></td>
                <td><?php echo e($item->longeur); ?></td>
                <td><?php echo e($item->largeur); ?></td>
                <td><?php echo e($item->prixcolori->epaisseur->titre ?? 'N/A'); ?></td>
                <td><?php echo e(number_format(($item->longeur / 1000) * ($item->largeur / 1000), 2)); ?></td>
                <td class="text-right"><?php echo e(number_format(($item->prixcolori->prix ?? 0) * (1 + ($devi->addperc / 100)), 2)); ?>€/m²</td>
                <td class="text-right"><?php echo e(number_format($item->montant, 2)); ?>€</td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php endif; ?>

    <?php if($devi->optionsdecoupes->count() > 0): ?>
    <h3>OPTIONS DE DÉCOUPE</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Option</th>
                <th>Quantité</th>
                <th class="text-right">Prix unitaire</th>
                <th class="text-right">Montant</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $devi->optionsdecoupes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($option->optionsdecoupe->titre); ?></td>
                <td><?php echo e($option->quantite); ?></td>
                <td class="text-right"><?php echo e(number_format($option->prixu * (1 + ($devi->addperc / 100)), 2)); ?>€</td>
                <td class="text-right"><?php echo e(number_format($option->montant, 2)); ?>€</td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php endif; ?>

    <?php if($devi->services->count() > 0): ?>
    <h3>SERVICES</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Service</th>
                <th class="text-right">Prix</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $devi->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($service->service->titre); ?></td>
                <td class="text-right"><?php echo e(number_format($service->devis_prix, 2)); ?>€</td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php endif; ?>

    <div class="total-section">
        <div class="total-box">
            <div class="total-ht">Total HT: <?php echo e(number_format($devi->total_ht, 2)); ?>€</div>
            <div>TVA (<?php echo e($devi->tva); ?>%): <?php echo e(number_format($devi->total_ht * ($devi->tva / 100), 2)); ?>€</div>
            <div class="total-ttc">Total TTC: <?php echo e(number_format($totalTTC, 2)); ?>€</div>
        </div>
    </div>

    <div class="footer">
        <p>Ce devis est valable 30 jours à compter de sa date d'émission.</p>
        <p>Conditions de paiement: Acompte de 50% à la commande, solde à la livraison.</p>
        <p>Délai de fabrication: 2 à 3 semaines après validation du devis.</p>
    </div>
</body>
</html>
<?php /**PATH /home/runner/workspace/resources/views/admin/devis/pdf-template.blade.php ENDPATH**/ ?>