<?php $__env->startSection('title', isset($role) ? 'Modifier Rôle' : 'Nouveau Rôle'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                <h1 class="page-heading d-flex text-gray-900 fw-bold fs-3 flex-column justify-content-center my-0">
                    <?php echo e(isset($role) ? 'Modifier Rôle' : 'Nouveau Rôle'); ?>

                </h1>
            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">
                <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-flex btn-secondary h-40px fs-7 fw-bold">Retour à la liste</a>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        <h3><?php echo e(isset($role) ? 'Modifier le rôle' : 'Créer un nouveau rôle'); ?></h3>
                    </div>
                </div>

                <form action="<?php echo e(isset($role) ? route('admin.roles.update', $role) : route('admin.roles.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php if(isset($role)): ?>
                        <?php echo method_field('PUT'); ?>
                    <?php endif; ?>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Nom d'affichage</label>
                                    <input type="text" name="display_name" class="form-control <?php $__errorArgs = ['display_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('display_name', $role->display_name ?? '')); ?>" required>
                                    <?php $__errorArgs = ['display_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Nom technique</label>
                                    <input type="text" name="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('name', $role->name ?? '')); ?>" required>
                                    <div class="form-text">Nom unique sans espaces (ex: admin, manager, user)</div>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-10 fv-row">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="3"><?php echo e(old('description', $role->description ?? '')); ?></textarea>
                                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-10 fv-row">
                                    <label class="required form-label">Ordre</label>
                                    <input type="number" name="ordre" class="form-control <?php $__errorArgs = ['ordre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('ordre', $role->ordre ?? 0)); ?>" min="0" required>
                                    <?php $__errorArgs = ['ordre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-10 fv-row">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" 
                                               <?php echo e(old('is_active', $role->is_active ?? true) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="is_active">
                                            Actif
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="separator border-gray-200 mb-10"></div>

                        <div class="mb-10">
                            <h4 class="mb-5">Permissions</h4>
                            <?php $__currentLoopData = $permissionsByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="card card-flush mb-5">
                                    <div class="card-header">
                                        <div class="card-title">
                                            <h5 class="m-0"><?php echo e(ucfirst($category)); ?></h5>
                                        </div>
                                        <div class="card-toolbar">
                                            <button type="button" class="btn btn-sm btn-light-primary" onclick="toggleCategoryPermissions('<?php echo e($category); ?>')">
                                                Tout sélectionner
                                            </button>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-md-4 mb-3">
                                                    <div class="form-check">
                                                        <input class="form-check-input permission-checkbox category-<?php echo e($category); ?>" 
                                                               type="checkbox" name="permissions[]" value="<?php echo e($permission->id); ?>" 
                                                               id="permission_<?php echo e($permission->id); ?>"
                                                               <?php echo e(isset($rolePermissions) && in_array($permission->id, $rolePermissions) ? 'checked' : ''); ?>>
                                                        <label class="form-check-label" for="permission_<?php echo e($permission->id); ?>">
                                                            <div>
                                                                <strong><?php echo e($permission->display_name); ?></strong>
                                                                <?php if($permission->description): ?>
                                                                    <div class="text-muted fs-7"><?php echo e($permission->description); ?></div>
                                                                <?php endif; ?>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="card-footer d-flex justify-content-end">
                        <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-light me-3">Annuler</a>
                        <button type="submit" class="btn btn-primary">
                            <?php echo e(isset($role) ? 'Modifier' : 'Créer'); ?> le rôle
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function toggleCategoryPermissions(category) {
    const checkboxes = document.querySelectorAll('.category-' + category);
    const allChecked = Array.from(checkboxes).every(cb => cb.checked);
    
    checkboxes.forEach(checkbox => {
        checkbox.checked = !allChecked;
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/workspace/resources/views/admin/roles/form.blade.php ENDPATH**/ ?>