<?php $__env->startSection('title', 'Gestion des Utilisateurs'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                <h1 class="page-heading d-flex text-gray-900 fw-bold fs-3 flex-column justify-content-center my-0">Gestion des Utilisateurs</h1>
            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">
                <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-sm fw-bold btn-primary">
                    <i class="ki-outline ki-plus fs-2"></i>Nouvel Utilisateur
                </a>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">

            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header border-0 pt-6">
                    <div class="card-title">
                        <div class="d-flex align-items-center position-relative my-1">
                            <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i>
                            <input type="text" data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-13" placeholder="Rechercher un utilisateur" />
                        </div>
                    </div>
                </div>

                <div class="card-body py-4">
                    <div class="table-responsive">
                        <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                            <thead>
                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                    <th class="min-w-125px">Utilisateur</th>
                                    <th class="min-w-125px">Email</th>
                                    <th class="min-w-125px">Rôle</th>
                                    <th class="min-w-125px">Date d'inscription</th>
                                    <th class="min-w-125px">Statut</th>
                                    <th class="text-end min-w-100px">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-semibold">
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="d-flex align-items-center">
                                        <div class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                            <div class="symbol-label">
                                                <img src="<?php echo e($user->image ? asset('storage/' . $user->image) : '/assets/media/avatars/300-1.jpg'); ?>" alt="<?php echo e($user->name); ?>" class="w-100" />
                                            </div>
                                        </div>
                                        <div class="d-flex flex-column">
                                            <a href="<?php echo e(route('admin.users.show', $user)); ?>" class="text-gray-800 text-hover-primary mb-1"><?php echo e($user->name); ?></a>
                                            <span class="text-muted fs-7">ID: <?php echo e($user->id); ?></span>
                                            <?php if($user->telephone): ?>
                                                <span class="text-muted fs-7"><?php echo e($user->telephone); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td>
                                        <?php if($user->role): ?>
                                            <span class="badge badge-light-primary"><?php echo e($user->role->display_name); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-light-secondary">Aucun rôle</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($user->created_at->format('d/m/Y H:i')); ?></td>
                                    <td>
                                        <?php if($user->is_active): ?>
                                            <span class="badge badge-light-success">Actif</span>
                                        <?php else: ?>
                                            <span class="badge badge-light-danger">Inactif</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end">
                                        <a href="#" class="btn btn-light btn-active-light-primary btn-flex btn-center btn-sm" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                            Actions
                                            <i class="ki-outline ki-down fs-5 ms-1"></i>
                                        </a>
                                        <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-4" data-kt-menu="true">
                                            <div class="menu-item px-3">
                                                <a href="<?php echo e(route('admin.users.show', $user)); ?>" class="menu-link px-3">Voir</a>
                                            </div>
                                            <div class="menu-item px-3">
                                                <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="menu-link px-3">Modifier</a>
                                            </div>
                                            <?php if($user->id !== auth()->id()): ?>
                                            <div class="menu-item px-3">
                                                <a href="<?php echo e(route('admin.users.toggle-status', $user)); ?>" class="menu-link px-3">
                                                    <?php echo e($user->is_active ? 'Désactiver' : 'Activer'); ?>

                                                </a>
                                            </div>
                                            <div class="menu-item px-3">
                                                <form action="<?php echo e(route('admin.users.destroy', $user)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cet utilisateur ?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-link text-danger p-0 menu-link px-3">Supprimer</button>
                                                </form>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <?php if($users->hasPages()): ?>
                    <div class="d-flex justify-content-center">
                        <?php echo e($users->links()); ?>

                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/workspace/resources/views/admin/users/index.blade.php ENDPATH**/ ?>