<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>Posts</h1>
    <a href="<?php echo e(route('posts.create')); ?>" class="btn btn-primary mb-3">Create New Post</a>
    
    <table class="table">
        <thead>
            <tr>
                <th>Title</th>
                <th>Category</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($post->title); ?></td>
                <td><?php echo e($post->category->title); ?></td>
                <td><?php echo e($post->pub ? 'Published' : 'Draft'); ?></td>
                <td>
                    <a href="<?php echo e(route('posts.edit', $post)); ?>" class="btn btn-sm btn-primary">Edit</a>
                    <form action="<?php echo e(route('posts.destroy', $post)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php echo e($posts->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/workspace/resources/views/posts/index.blade.php ENDPATH**/ ?>